/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.phar.wizard;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.php.internal.core.phar.IFileExporter;
import org.eclipse.php.internal.core.phar.IStub;
import org.eclipse.php.internal.core.phar.IStubProvider;
import org.eclipse.php.internal.core.phar.PharPackage;
import org.eclipse.php.internal.core.phar.StubProvider;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.phar.wizard.PharBuilder;
import org.eclipse.php.internal.ui.phar.wizard.PharExportHelper;
import org.eclipse.php.internal.ui.phar.wizard.PharUIUtil;
import org.eclipse.swt.widgets.Shell;

public class PlainPharBuilder
extends PharBuilder {
    public static final String BUILDER_ID = "org.eclipse.php.ui.plain_phar_builder";
    private PharPackage fJarPackage;
    IFileExporter fileExporter;

    @Override
    public String getId() {
        return BUILDER_ID;
    }

    @Override
    public IStubProvider getStubProvider() {
        return new StubProvider();
    }

    @Override
    public void open(PharPackage jarPackage, Shell displayShell, MultiStatus statusMsg) throws CoreException {
        super.open(jarPackage, displayShell, statusMsg);
        this.fJarPackage = jarPackage;
        Assert.isTrue((boolean)this.fJarPackage.isValid(), (String)"The PHAR package specification is invalid");
        if (!this.canCreateJar(displayShell)) {
            throw new OperationCanceledException();
        }
        try {
            this.fileExporter = PharExportHelper.createFileExporter(this.fJarPackage);
        }
        catch (IOException ex) {
            throw PharUIUtil.createCoreException(ex.getLocalizedMessage(), ex);
        }
    }

    protected boolean canCreateJar(Shell parent) {
        File file = this.fJarPackage.getAbsolutePharLocation().toFile();
        if (file.exists()) {
            if (!file.canWrite()) {
                return false;
            }
            if (this.fJarPackage.allowOverwrite()) {
                return true;
            }
            return parent != null && PharUIUtil.askForOverwritePermission(parent, this.fJarPackage.getAbsolutePharLocation(), true);
        }
        String path = file.getAbsolutePath();
        int separatorIndex = path.lastIndexOf(File.separator);
        if (separatorIndex == -1) {
            return true;
        }
        File directory = new File(path.substring(0, separatorIndex));
        if (!directory.exists()) {
            if (PharUIUtil.askToCreateDirectory(parent, directory)) {
                return directory.mkdirs();
            }
            return false;
        }
        return true;
    }

    @Override
    public void writeFile(IFile resource, IPath destinationPath) throws CoreException {
        try {
            this.fileExporter.write(resource, destinationPath.toString());
        }
        catch (IOException ex) {
            throw PharUIUtil.createCoreException(ex.getLocalizedMessage(), ex);
        }
    }

    @Override
    public void writeStub(IStub stub, IProgressMonitor progressMonitor) throws CoreException {
        try {
            this.fileExporter.writeStub(stub);
        }
        catch (IOException ex) {
            throw PharUIUtil.createCoreException(ex.getLocalizedMessage(), ex);
        }
    }

    @Override
    public void close() throws CoreException {
        if (this.fileExporter != null) {
            try {
                this.fileExporter.finished();
                this.registerInWorkspaceIfNeeded();
            }
            catch (IOException ex) {
                throw PharUIUtil.createCoreException(ex.getLocalizedMessage(), ex);
            }
        }
    }

    private void registerInWorkspaceIfNeeded() {
        IPath jarPath = this.fJarPackage.getAbsolutePharLocation();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            IPath projectLocation = project.getLocation();
            if (projectLocation != null && projectLocation.isPrefixOf(jarPath)) {
                try {
                    jarPath = jarPath.removeFirstSegments(projectLocation.segmentCount());
                    jarPath = jarPath.removeLastSegments(1);
                    IResource containingFolder = project.findMember(jarPath);
                    if (containingFolder != null && containingFolder.isAccessible()) {
                        containingFolder.refreshLocal(1, null);
                    }
                }
                catch (CoreException ex) {
                    PHPUiPlugin.log(ex);
                }
            }
            ++i;
        }
    }

    @Override
    public void writeSignature(IProgressMonitor monitor) throws CoreException {
        if (this.fileExporter != null) {
            try {
                this.fileExporter.writeSignature();
            }
            catch (IOException ex) {
                throw PharUIUtil.createCoreException(ex.getLocalizedMessage(), ex);
            }
        }
    }

    @Override
    public void writeFile(IFolder resource, IPath destinationPath) throws CoreException {
        try {
            this.fileExporter.write(resource, destinationPath.toString());
        }
        catch (IOException ex) {
            throw PharUIUtil.createCoreException(ex.getLocalizedMessage(), ex);
        }
    }
}

