/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.errors;

import org.eclipse.wb.core.editor.errors.IExceptionRewriter;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.os.OSSupportError;

public class CoreExceptionRewriter
implements IExceptionRewriter {
    public static final IExceptionRewriter INSTANCE = new CoreExceptionRewriter();

    private CoreExceptionRewriter() {
    }

    @Override
    public Throwable rewrite(Throwable e) {
        Throwable rootException = DesignerExceptionUtils.getRootCause(e);
        if (rootException instanceof OSSupportError) {
            return new DesignerException(900, e, new Object[0]);
        }
        if (CoreExceptionRewriter.isIncompleteProductException(rootException)) {
            return new DesignerException(2, e, new Object[0]);
        }
        return e;
    }

    private static boolean isIncompleteProductException(Throwable e) {
        if (e instanceof NoSuchMethodError) {
            return e.getMessage().startsWith("org.eclipse.wb.");
        }
        if (e instanceof NoClassDefFoundError) {
            String message = e.getMessage();
            return message.startsWith("org/eclipse/wb/") || message.startsWith("org/eclipse/jdt/");
        }
        return false;
    }
}

