/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.exception;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;

public class DesignerException
extends Error {
    private static final long serialVersionUID = 0L;
    private final int m_code;
    private final Object[] m_parameters;
    private final Throwable m_cause;
    private int m_sourcePosition = -1;

    public DesignerException(int code, Object ... parameters) {
        this(code, null, parameters);
    }

    public DesignerException(int code, Throwable cause, Object ... parameters) {
        super(cause);
        this.m_code = code;
        this.m_parameters = parameters;
        this.m_cause = cause;
    }

    public int getCode() {
        return this.m_code;
    }

    public Object[] getParameters() {
        return this.m_parameters;
    }

    @Override
    public String getMessage() {
        String message = this.m_code + " (" + DesignerExceptionUtils.getExceptionTitle(this.m_code) + ").";
        if (this.m_parameters.length != 0) {
            message = message + " " + StringUtils.join((Object[])this.m_parameters, (String)" ");
        }
        return message;
    }

    @Override
    public Throwable getCause() {
        return this.m_cause;
    }

    public void setSourcePosition(int sourcePosition) {
        this.m_sourcePosition = sourcePosition;
    }

    public int getSourcePosition() {
        return this.m_sourcePosition;
    }
}

