/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.jface.resource;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.AssociationObject;
import org.eclipse.wb.core.model.association.AssociationObjects;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.generation.statement.PureFlatStatementGenerator;
import org.eclipse.wb.internal.core.model.generation.statement.StatementGenerator;
import org.eclipse.wb.internal.core.model.order.MethodOrder;
import org.eclipse.wb.internal.core.model.variable.FieldUniqueVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.BodyDeclarationTarget;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.swt.model.jface.resource.ManagerContainerInfo;
import org.eclipse.wb.internal.swt.model.jface.resource.ResourceManagerInfo;

public class LocalResourceManagerInfo
extends ResourceManagerInfo {
    public LocalResourceManagerInfo(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(editor, description, creationSupport);
    }

    static LocalResourceManagerInfo createNew(JavaInfo root) throws Exception {
        Assert.isTrue((boolean)root.isRoot());
        AstEditor editor = root.getEditor();
        LocalResourceManagerInfo resourceManager = (LocalResourceManagerInfo)JavaInfoUtils.createJavaInfo((AstEditor)editor, LocalResourceManager.class, (CreationSupport)new ConstructorCreationSupport());
        LocalResourceManagerInfo.createSourceEntry(root, resourceManager);
        return resourceManager;
    }

    private static void createSourceEntry(JavaInfo root, final LocalResourceManagerInfo resourceManager) throws Exception {
        Assert.isTrue((boolean)root.isRoot());
        AstEditor editor = root.getEditor();
        VariableSupport rootVariableSupport = root.getVariableSupport();
        StatementTarget rootTarget = rootVariableSupport.getStatementTarget();
        String methodSignature = "createResourceManager()";
        String methodHeader = "private void createResourceManager()";
        String methodInvocation = "createResourceManager()";
        TypeDeclaration typeDeclaration = JavaInfoUtils.getTypeDeclaration((JavaInfo)root);
        MethodDeclaration managerMethod = AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)methodSignature);
        if (managerMethod == null) {
            MethodDeclaration rootMethod = editor.getEnclosingMethod(rootTarget.getPosition());
            managerMethod = editor.addMethodDeclaration(methodHeader, Collections.emptyList(), new BodyDeclarationTarget((BodyDeclaration)rootMethod, false));
            root.addExpressionStatement(rootTarget, methodInvocation);
        }
        StatementTarget managerTarget = new StatementTarget(managerMethod, true);
        CreationSupport creationSupport = new CreationSupport(){

            public boolean isJavaInfo(ASTNode node) {
                return false;
            }

            public ASTNode getNode() {
                return null;
            }

            public String add_getSource(NodeTarget target) throws Exception {
                return "new org.eclipse.jface.resource.LocalResourceManager(org.eclipse.jface.resource.JFaceResources.getResources(),%parent%)";
            }

            public void add_setSourceExpression(Expression expression) throws Exception {
                ClassInstanceCreation creation = (ClassInstanceCreation)expression;
                resourceManager.setCreationSupport((CreationSupport)new ConstructorCreationSupport(creation));
                resourceManager.bindToExpression((Expression)creation);
            }
        };
        resourceManager.setCreationSupport(creationSupport);
        JavaInfoUtils.add((JavaInfo)resourceManager, (VariableSupport)new FieldUniqueVariableSupport((JavaInfo)resourceManager), (StatementGenerator)PureFlatStatementGenerator.INSTANCE, (AssociationObject)AssociationObjects.empty(), (JavaInfo)root, null, (StatementTarget)managerTarget);
        root.removeChild((ObjectInfo)resourceManager);
        root.getDescription().setDefaultMethodOrder((MethodOrder)new MethodOrderAfterResourceManager());
        ManagerContainerInfo.get(root).addChild((ObjectInfo)resourceManager);
    }

    static final class MethodOrderAfterResourceManager
    extends MethodOrder {
        MethodOrderAfterResourceManager() {
        }

        public boolean canReference(JavaInfo javaInfo) {
            return true;
        }

        protected StatementTarget getSpecificTarget(JavaInfo javaInfo, String newSignature) throws Exception {
            ResourceManagerInfo targetInfo = null;
            MethodOrder defaultMethodOrder = MethodOrder.parse((String)"afterCreation");
            for (ManagerContainerInfo child : javaInfo.getChildren(ManagerContainerInfo.class)) {
                Iterator iterator = child.getChildren(ResourceManagerInfo.class).iterator();
                while (iterator.hasNext()) {
                    ResourceManagerInfo grandChild;
                    targetInfo = grandChild = (ResourceManagerInfo)((Object)iterator.next());
                }
            }
            if (targetInfo == null) {
                return defaultMethodOrder.getTarget(javaInfo, newSignature);
            }
            StatementTarget targetStatement = targetInfo.getVariableSupport().getStatementTarget();
            MethodDeclaration targetDeclaration = AstNodeUtils.getEnclosingMethod((ASTNode)targetStatement.getStatement());
            if (targetDeclaration.isConstructor()) {
                return new StatementTarget(targetStatement.getStatement(), false);
            }
            AstEditor editor = javaInfo.getEditor();
            VariableSupport rootVariableSupport = javaInfo.getRootJava().getVariableSupport();
            StatementTarget rootStatement = rootVariableSupport.getStatementTarget();
            MethodDeclaration rootMethod = editor.getEnclosingMethod(rootStatement.getPosition());
            MethodInvocation targetInvocation = null;
            for (Statement statement : DomGenerics.statements((MethodDeclaration)rootMethod)) {
                MethodInvocation methodInvocation;
                ExpressionStatement expressionStatement;
                Expression expression;
                if (!(statement instanceof ExpressionStatement) || !((expression = (expressionStatement = (ExpressionStatement)statement).getExpression()) instanceof MethodInvocation) || !this.isConstructorInvocation(methodInvocation = (MethodInvocation)expression, targetDeclaration)) continue;
                targetInvocation = methodInvocation;
                break;
            }
            if (targetInvocation == null) {
                return defaultMethodOrder.getTarget(javaInfo, newSignature);
            }
            return new StatementTarget(targetInvocation, false);
        }

        private boolean isConstructorInvocation(final MethodInvocation rootInvocation, final MethodDeclaration targetDeclaration) {
            final AtomicBoolean result = new AtomicBoolean(false);
            MethodDeclaration rootDeclaration = AstNodeUtils.getLocalMethodDeclaration((MethodInvocation)rootInvocation);
            if (rootDeclaration != null) {
                rootDeclaration.accept(new ASTVisitor(){

                    public boolean visit(MethodInvocation methodInvocation) {
                        MethodDeclaration methodDeclaration = AstNodeUtils.getLocalMethodDeclaration((MethodInvocation)rootInvocation);
                        if (targetDeclaration.equals((Object)methodDeclaration)) {
                            result.set(true);
                        } else if (methodDeclaration != null) {
                            result.set(this.isConstructorInvocation(methodInvocation, targetDeclaration));
                        }
                        return !result.get();
                    }
                });
            }
            return result.get();
        }
    }
}

