/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.js.launchers;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.jsdt.chromium.debug.core.model.LaunchParams;
import org.eclipse.wst.jsdt.chromium.debug.js.JSDebuggerPlugin;
import org.eclipse.wst.jsdt.chromium.debug.js.launch.LaunchConstants;

public class WIPLauncher {
    public static void launch(IProject project, String resourceRelativePath, String url, int port) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = launchManager.getLaunchConfigurationType("org.eclipse.wst.jsdt.chromium.debug.ui.LaunchType$Wip");
        String projectName = project.getName();
        final ILaunchConfigurationWorkingCopy chromiumLaunch = type.newInstance((IContainer)project, projectName);
        chromiumLaunch.setAttribute("debug_host", "localhost");
        chromiumLaunch.setAttribute("debug_port", port);
        chromiumLaunch.setAttribute("add_network_console", false);
        chromiumLaunch.setAttribute("breakpoint_startup_sync_direction", "MERGE");
        chromiumLaunch.setAttribute("source_lookup_mode", "EXACT_MATCH");
        chromiumLaunch.setAttribute(LaunchParams.PredefinedSourceWrapperIds.CONFIG_PROPERTY, WIPLauncher.encode(LaunchConstants.PREDEFIENED_WRAPPERS));
        chromiumLaunch.setAttribute("attr_app_project", projectName);
        chromiumLaunch.setAttribute("attr_app_project_relative_path", resourceRelativePath);
        chromiumLaunch.setAttribute("attr_base_url", url);
        chromiumLaunch.setAttribute("wip_backend_id", "current development");
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1500L);
                    DebugUITools.launch((ILaunchConfiguration)chromiumLaunch, (String)"debug");
                }
                catch (InterruptedException e) {
                    JSDebuggerPlugin.logError(e, e.getMessage());
                }
            }
        });
    }

    public static String encode(List<String> wrappers) {
        StringBuilder output = new StringBuilder();
        Collections.sort(wrappers);
        for (String wrapper : wrappers) {
            output.append(wrapper.length());
            output.append('(').append(wrapper).append(')');
        }
        return output.toString();
    }
}

