/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.assertj.version;

import java.util.Objects;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.ComparableAssert;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public abstract class AbstractVersionAssert<SELF extends AbstractVersionAssert<SELF, ACTUAL>, ACTUAL extends Version>
extends AbstractComparableAssert<SELF, ACTUAL>
implements ComparableAssert<SELF, ACTUAL> {
    protected AbstractVersionAssert(ACTUAL actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public AbstractIntegerAssert<?> hasMajorThat() {
        return (AbstractIntegerAssert)((AbstractVersionAssert)this.isNotNull()).extracting(Version::getMajor, InstanceOfAssertFactories.INTEGER);
    }

    public SELF hasMajor(int expected) {
        this.isNotNull();
        int a = ((Version)this.actual).getMajor();
        if (expected != a) {
            throw this.failureWithActualExpected(a, expected, "%nExpecting%n <%s>%nto have major version:%n  <%d>%n but it was:%n  <%d>", new Object[]{this.actual, expected, a});
        }
        return (SELF)((Object)((AbstractVersionAssert)this.myself));
    }

    public AbstractIntegerAssert<?> hasMinorThat() {
        return (AbstractIntegerAssert)((AbstractVersionAssert)this.isNotNull()).extracting(Version::getMinor, InstanceOfAssertFactories.INTEGER);
    }

    public SELF hasMinor(int expected) {
        this.isNotNull();
        int a = ((Version)this.actual).getMinor();
        if (expected != a) {
            throw this.failureWithActualExpected(a, expected, "%nExpecting%n <%s>%nto have minor version:%n  <%d>%n but it was:%n  <%d>", new Object[]{this.actual, expected, a});
        }
        return (SELF)((Object)((AbstractVersionAssert)this.myself));
    }

    public AbstractIntegerAssert<?> hasMicroThat() {
        return (AbstractIntegerAssert)((AbstractVersionAssert)this.isNotNull()).extracting(Version::getMicro, InstanceOfAssertFactories.INTEGER);
    }

    public SELF hasMicro(int expected) {
        this.isNotNull();
        int a = ((Version)this.actual).getMicro();
        if (expected != a) {
            throw this.failureWithActualExpected(a, expected, "%nExpecting%n <%s>%nto have micro version:%n <%d>%n but it was:%n <%d>", new Object[]{this.actual, expected, a});
        }
        return (SELF)((Object)((AbstractVersionAssert)this.myself));
    }

    public AbstractStringAssert<?> hasQualifierThat() {
        return (AbstractStringAssert)((AbstractVersionAssert)this.isNotNull()).extracting(Version::getQualifier, InstanceOfAssertFactories.STRING);
    }

    public SELF hasQualifier(String expected) {
        this.isNotNull();
        String a = ((Version)this.actual).getQualifier();
        if (!Objects.equals(a, expected)) {
            throw this.failureWithActualExpected(a, expected, "%nExpecting%n <%s>%nto have qualifier:%n <%s>%n but it was:%n <%s>", new Object[]{this.actual, expected, a});
        }
        return (SELF)((Object)((AbstractVersionAssert)this.myself));
    }

    public SELF isEmpty() {
        return (SELF)((Object)((AbstractVersionAssert)this.isEqualTo(Version.emptyVersion)));
    }

    public SELF isInRange(String range) {
        return this.isInRange(VersionRange.valueOf((String)range));
    }

    public SELF isInRange(VersionRange range) {
        this.isNotNull();
        if (!range.includes((Version)this.actual)) {
            throw this.failure("%nExpecting%n <%s>%nto be in range:%n <%s>%n but it was not", new Object[]{this.actual, range});
        }
        return (SELF)((Object)((AbstractVersionAssert)this.myself));
    }

    public SELF isNotInRange(String range) {
        return this.isNotInRange(VersionRange.valueOf((String)range));
    }

    public SELF isNotInRange(VersionRange range) {
        this.isNotNull();
        if (range.includes((Version)this.actual)) {
            throw this.failure("%nExpecting%n <%s>%nto not be in range:%n <%s>%n but it was", new Object[]{this.actual, range});
        }
        return (SELF)((Object)((AbstractVersionAssert)this.myself));
    }
}

