/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.rap.rwt.addons.canvas.ClientCanvas;
import org.eclipse.rap.rwt.addons.canvas.ClientDrawListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public final class ClientCanvasTab
extends ExampleTab {
    private static final List<int[]> ERNIE = new ArrayList<int[]>();
    private static final boolean LABEL_ALL_DOTS = false;
    private static final boolean RENUMBER_LABELS = true;
    private static final boolean SHOW_BLUE_PRINT = false;
    private static final int[] HAIR = new int[]{22, 93};
    private static final int[] LEFT_EYE = new int[]{163, 168};
    private static final int[] RIGHT_EYE = new int[]{158, 162};
    private static final int[] NECK = new int[]{169, 178};
    private static final int[] MOUTH = new int[]{108, 118};
    private static final List<int[]> ALLREADY_DRAWN_SUBSETS = new ArrayList<int[]>();
    private static float scaleFactor;
    private static Point ernieDimensions;
    private static Point ernieMinima;
    private Image bgPatternImage;
    protected int currentColor = 4;
    protected int currentLineWidth = 8;
    protected int alpha = 255;
    private ClientCanvas canvas;
    private ToolItem redoToolItem;
    private ToolItem undoToolItem;
    private ToolItem clearToolItem;

    static {
        ALLREADY_DRAWN_SUBSETS.add(HAIR);
        ALLREADY_DRAWN_SUBSETS.add(LEFT_EYE);
        ALLREADY_DRAWN_SUBSETS.add(RIGHT_EYE);
        ALLREADY_DRAWN_SUBSETS.add(NECK);
        ALLREADY_DRAWN_SUBSETS.add(MOUTH);
        ClientCanvasTab.addToErnie(0, 95, 125);
        ClientCanvasTab.addToErnie(1, 81, 166);
        ClientCanvasTab.addToErnie(2, 61, 194);
        ClientCanvasTab.addToErnie(3, 55, 233);
        ClientCanvasTab.addToErnie(4, 82, 286);
        ClientCanvasTab.addToErnie(5, 108, 315);
        ClientCanvasTab.addToErnie(6, 123, 332);
        ClientCanvasTab.addToErnie(7, 139, 342);
        ClientCanvasTab.addToErnie(8, 158, 354);
        ClientCanvasTab.addToErnie(9, 184, 363);
        ClientCanvasTab.addToErnie(10, 218, 372);
        ClientCanvasTab.addToErnie(11, 249, 369);
        ClientCanvasTab.addToErnie(12, 280, 361);
        ClientCanvasTab.addToErnie(13, 310, 350);
        ClientCanvasTab.addToErnie(14, 326, 333);
        ClientCanvasTab.addToErnie(15, 342, 324);
        ClientCanvasTab.addToErnie(16, 368, 298);
        ClientCanvasTab.addToErnie(17, 381, 282);
        ClientCanvasTab.addToErnie(18, 391, 267);
        ClientCanvasTab.addToErnie(19, 401, 242);
        ClientCanvasTab.addToErnie(20, 399, 221);
        ClientCanvasTab.addToErnie(21, 387, 198);
        ClientCanvasTab.addToErnie(22, 362, 150);
        ClientCanvasTab.addToErnie(179, 362, 150);
        ClientCanvasTab.addToErnie(23, 332, 135);
        ClientCanvasTab.addToErnie(24, 305, 121);
        ClientCanvasTab.addToErnie(25, 281, 116);
        ClientCanvasTab.addToErnie(26, 258, 115);
        ClientCanvasTab.addToErnie(27, 244, 121);
        ClientCanvasTab.addToErnie(28, 221, 114);
        ClientCanvasTab.addToErnie(29, 191, 113);
        ClientCanvasTab.addToErnie(30, 163, 121);
        ClientCanvasTab.addToErnie(31, 131, 127);
        ClientCanvasTab.addToErnie(32, 95, 125);
        ClientCanvasTab.addToErnie(33, 76, 109);
        ClientCanvasTab.addToErnie(34, 96, 108);
        ClientCanvasTab.addToErnie(35, 82, 94);
        ClientCanvasTab.addToErnie(36, 79, 73);
        ClientCanvasTab.addToErnie(37, 106, 85);
        ClientCanvasTab.addToErnie(38, 99, 74);
        ClientCanvasTab.addToErnie(39, 98, 66);
        ClientCanvasTab.addToErnie(40, 110, 71);
        ClientCanvasTab.addToErnie(41, 129, 71);
        ClientCanvasTab.addToErnie(42, 123, 61);
        ClientCanvasTab.addToErnie(43, 115, 56);
        ClientCanvasTab.addToErnie(44, 132, 51);
        ClientCanvasTab.addToErnie(45, 151, 50);
        ClientCanvasTab.addToErnie(46, 141, 38);
        ClientCanvasTab.addToErnie(47, 156, 38);
        ClientCanvasTab.addToErnie(48, 174, 43);
        ClientCanvasTab.addToErnie(49, 162, 30);
        ClientCanvasTab.addToErnie(50, 149, 29);
        ClientCanvasTab.addToErnie(51, 165, 22);
        ClientCanvasTab.addToErnie(52, 185, 27);
        ClientCanvasTab.addToErnie(53, 183, 14);
        ClientCanvasTab.addToErnie(54, 186, 2);
        ClientCanvasTab.addToErnie(55, 197, 13);
        ClientCanvasTab.addToErnie(56, 211, 24);
        ClientCanvasTab.addToErnie(57, 215, 15);
        ClientCanvasTab.addToErnie(58, 209, 8);
        ClientCanvasTab.addToErnie(59, 224, 11);
        ClientCanvasTab.addToErnie(60, 233, 18);
        ClientCanvasTab.addToErnie(61, 248, 16);
        ClientCanvasTab.addToErnie(62, 266, 6);
        ClientCanvasTab.addToErnie(63, 276, 1);
        ClientCanvasTab.addToErnie(64, 275, 9);
        ClientCanvasTab.addToErnie(65, 272, 20);
        ClientCanvasTab.addToErnie(66, 294, 12);
        ClientCanvasTab.addToErnie(67, 322, 8);
        ClientCanvasTab.addToErnie(68, 307, 15);
        ClientCanvasTab.addToErnie(69, 299, 26);
        ClientCanvasTab.addToErnie(70, 315, 26);
        ClientCanvasTab.addToErnie(71, 326, 26);
        ClientCanvasTab.addToErnie(72, 311, 35);
        ClientCanvasTab.addToErnie(73, 340, 35);
        ClientCanvasTab.addToErnie(74, 331, 50);
        ClientCanvasTab.addToErnie(75, 353, 50);
        ClientCanvasTab.addToErnie(76, 368, 54);
        ClientCanvasTab.addToErnie(77, 350, 58);
        ClientCanvasTab.addToErnie(78, 379, 62);
        ClientCanvasTab.addToErnie(79, 396, 70);
        ClientCanvasTab.addToErnie(80, 378, 72);
        ClientCanvasTab.addToErnie(81, 368, 81);
        ClientCanvasTab.addToErnie(82, 388, 84);
        ClientCanvasTab.addToErnie(83, 369, 93);
        ClientCanvasTab.addToErnie(84, 383, 102);
        ClientCanvasTab.addToErnie(85, 410, 101);
        ClientCanvasTab.addToErnie(86, 394, 109);
        ClientCanvasTab.addToErnie(87, 379, 113);
        ClientCanvasTab.addToErnie(88, 394, 125);
        ClientCanvasTab.addToErnie(89, 410, 122);
        ClientCanvasTab.addToErnie(90, 405, 133);
        ClientCanvasTab.addToErnie(91, 386, 133);
        ClientCanvasTab.addToErnie(92, 395, 143);
        ClientCanvasTab.addToErnie(93, 365, 155);
        ClientCanvasTab.addToErnie(100, 58, 157);
        ClientCanvasTab.addToErnie(101, 31, 170);
        ClientCanvasTab.addToErnie(102, 22, 207);
        ClientCanvasTab.addToErnie(103, 35, 227);
        ClientCanvasTab.addToErnie(104, 407, 194);
        ClientCanvasTab.addToErnie(105, 433, 211);
        ClientCanvasTab.addToErnie(106, 436, 241);
        ClientCanvasTab.addToErnie(107, 417, 267);
        ClientCanvasTab.addToErnie(108, 74, 217);
        ClientCanvasTab.addToErnie(109, 85, 229);
        ClientCanvasTab.addToErnie(110, 102, 239);
        ClientCanvasTab.addToErnie(111, 152, 255);
        ClientCanvasTab.addToErnie(112, 178, 261);
        ClientCanvasTab.addToErnie(113, 226, 269);
        ClientCanvasTab.addToErnie(114, 276, 271);
        ClientCanvasTab.addToErnie(115, 315, 268);
        ClientCanvasTab.addToErnie(116, 352, 257);
        ClientCanvasTab.addToErnie(117, 375, 250);
        ClientCanvasTab.addToErnie(118, 387, 240);
        ClientCanvasTab.addToErnie(119, 340, 278);
        ClientCanvasTab.addToErnie(120, 317, 297);
        ClientCanvasTab.addToErnie(121, 276, 322);
        ClientCanvasTab.addToErnie(122, 230, 332);
        ClientCanvasTab.addToErnie(123, 182, 323);
        ClientCanvasTab.addToErnie(124, 154, 306);
        ClientCanvasTab.addToErnie(125, 132, 285);
        ClientCanvasTab.addToErnie(126, 112, 260);
        ClientCanvasTab.addToErnie(127, 103, 244);
        ClientCanvasTab.addToErnie(128, 178, 265);
        ClientCanvasTab.addToErnie(129, 195, 287);
        ClientCanvasTab.addToErnie(130, 228, 301);
        ClientCanvasTab.addToErnie(131, 253, 295);
        ClientCanvasTab.addToErnie(132, 270, 282);
        ClientCanvasTab.addToErnie(133, 226, 281);
        ClientCanvasTab.addToErnie(134, 188, 228);
        ClientCanvasTab.addToErnie(135, 191, 201);
        ClientCanvasTab.addToErnie(136, 209, 184);
        ClientCanvasTab.addToErnie(137, 234, 180);
        ClientCanvasTab.addToErnie(138, 257, 189);
        ClientCanvasTab.addToErnie(139, 269, 217);
        ClientCanvasTab.addToErnie(140, 258, 248);
        ClientCanvasTab.addToErnie(141, 242, 259);
        ClientCanvasTab.addToErnie(142, 170, 198);
        ClientCanvasTab.addToErnie(143, 152, 186);
        ClientCanvasTab.addToErnie(144, 152, 156);
        ClientCanvasTab.addToErnie(145, 167, 144);
        ClientCanvasTab.addToErnie(146, 191, 131);
        ClientCanvasTab.addToErnie(147, 215, 136);
        ClientCanvasTab.addToErnie(148, 225, 154);
        ClientCanvasTab.addToErnie(149, 221, 176);
        ClientCanvasTab.addToErnie(150, 243, 166);
        ClientCanvasTab.addToErnie(151, 254, 148);
        ClientCanvasTab.addToErnie(152, 271, 135);
        ClientCanvasTab.addToErnie(153, 294, 138);
        ClientCanvasTab.addToErnie(154, 317, 165);
        ClientCanvasTab.addToErnie(155, 316, 191);
        ClientCanvasTab.addToErnie(156, 300, 204);
        ClientCanvasTab.addToErnie(157, 282, 207);
        ClientCanvasTab.addToErnie(158, 273, 184);
        ClientCanvasTab.addToErnie(159, 289, 181);
        ClientCanvasTab.addToErnie(160, 295, 169);
        ClientCanvasTab.addToErnie(161, 281, 158);
        ClientCanvasTab.addToErnie(162, 265, 168);
        ClientCanvasTab.addToErnie(163, 189, 181);
        ClientCanvasTab.addToErnie(164, 176, 172);
        ClientCanvasTab.addToErnie(165, 180, 155);
        ClientCanvasTab.addToErnie(166, 195, 153);
        ClientCanvasTab.addToErnie(167, 203, 167);
        ClientCanvasTab.addToErnie(168, 202, 178);
        ClientCanvasTab.addToErnie(169, 120, 346);
        ClientCanvasTab.addToErnie(170, 131, 366);
        ClientCanvasTab.addToErnie(171, 150, 380);
        ClientCanvasTab.addToErnie(172, 182, 397);
        ClientCanvasTab.addToErnie(173, 217, 404);
        ClientCanvasTab.addToErnie(174, 249, 405);
        ClientCanvasTab.addToErnie(175, 285, 396);
        ClientCanvasTab.addToErnie(176, 309, 382);
        ClientCanvasTab.addToErnie(177, 332, 363);
        ClientCanvasTab.addToErnie(178, 344, 343);
        ClientCanvasTab.determineErnieDimensions();
        scaleFactor = 1.0f;
    }

    public ClientCanvasTab() {
        super("ClientCanvas");
        int[] nArray = new int[2];
        nArray[0] = 100;
        this.setHorizontalSashFormWeights(nArray);
    }

    @Override
    protected void createStyleControls(Composite parent) {
    }

    @Override
    protected void createExampleControls(Composite parent) {
        Display display = parent.getDisplay();
        parent.setLayout((Layout)this.createGridLayout(1, false));
        this.createToolbar(display, parent);
        this.createClientCanvas(display, parent);
        this.registerControl((Control)this.canvas);
    }

    private void createToolbar(Display display, Composite parent) {
        ToolBar toolBar = new ToolBar(parent, 256);
        toolBar.setLayoutData((Object)new GridData(4, 128, true, false));
        ToolItem widthThinToolItem = new ToolItem(toolBar, 8);
        String iconPath = "/resources/line-width-thin.png";
        widthThinToolItem.setImage(new Image((Device)display, ClientCanvasTab.class.getResourceAsStream(iconPath)));
        widthThinToolItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ClientCanvasTab.this.currentLineWidth = 1;
                ClientCanvasTab.this.canvas.redraw();
            }
        });
        ToolItem widthMediumToolItem = new ToolItem(toolBar, 8);
        iconPath = "/resources/line-width-medium.png";
        widthMediumToolItem.setImage(new Image((Device)display, ClientCanvasTab.class.getResourceAsStream(iconPath)));
        widthMediumToolItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ClientCanvasTab.this.currentLineWidth = 8;
                ClientCanvasTab.this.canvas.redraw();
            }
        });
        ToolItem widthThickToolItem = new ToolItem(toolBar, 8);
        iconPath = "/resources/line-width-thick.png";
        widthThickToolItem.setImage(new Image((Device)display, ClientCanvasTab.class.getResourceAsStream(iconPath)));
        widthThickToolItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ClientCanvasTab.this.currentLineWidth = 16;
                ClientCanvasTab.this.canvas.redraw();
            }
        });
        final ToolItem opacityToolItem = new ToolItem(toolBar, 8);
        opacityToolItem.setText("Opaque");
        opacityToolItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (ClientCanvasTab.this.alpha == 255) {
                    ClientCanvasTab.this.alpha = 128;
                    opacityToolItem.setText("Transparent");
                } else {
                    ClientCanvasTab.this.alpha = 255;
                    opacityToolItem.setText("Opaque");
                }
                ClientCanvasTab.this.canvas.redraw();
            }
        });
        ToolItem colorRedToolItem = new ToolItem(toolBar, 8);
        colorRedToolItem.setText("Red");
        colorRedToolItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ClientCanvasTab.this.currentColor = 4;
                ClientCanvasTab.this.canvas.redraw();
            }
        });
        ToolItem colorGreenToolItem = new ToolItem(toolBar, 8);
        colorGreenToolItem.setText("Green");
        colorGreenToolItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ClientCanvasTab.this.currentColor = 6;
                ClientCanvasTab.this.canvas.redraw();
            }
        });
        ToolItem colorBlueToolItem = new ToolItem(toolBar, 8);
        colorBlueToolItem.setText("Blue");
        colorBlueToolItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ClientCanvasTab.this.currentColor = 10;
                ClientCanvasTab.this.canvas.redraw();
            }
        });
        this.undoToolItem = new ToolItem(toolBar, 8);
        iconPath = "/resources/undo.png";
        this.undoToolItem.setImage(new Image((Device)display, ClientCanvasTab.class.getResourceAsStream(iconPath)));
        this.undoToolItem.setEnabled(false);
        this.undoToolItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ClientCanvasTab.this.canvas.undo();
                ClientCanvasTab.this.undoToolItem.setEnabled(ClientCanvasTab.this.canvas.hasUndo());
                ClientCanvasTab.this.clearToolItem.setEnabled(ClientCanvasTab.this.canvas.hasUndo());
            }
        });
        this.redoToolItem = new ToolItem(toolBar, 8);
        iconPath = "/resources/redo.png";
        this.redoToolItem.setImage(new Image((Device)display, ClientCanvasTab.class.getResourceAsStream(iconPath)));
        this.redoToolItem.setEnabled(false);
        this.redoToolItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ClientCanvasTab.this.canvas.redo();
                ClientCanvasTab.this.redoToolItem.setEnabled(ClientCanvasTab.this.canvas.hasRedo());
            }
        });
        this.clearToolItem = new ToolItem(toolBar, 8);
        this.clearToolItem.setText("Clear");
        this.clearToolItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ClientCanvasTab.this.canvas.clear();
            }
        });
    }

    private void createClientCanvas(final Display display, Composite mainComp) {
        this.canvas = new ClientCanvas(mainComp, 0);
        this.canvas.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.bgPatternImage != null) {
            this.canvas.setBackgroundImage(this.bgPatternImage);
        } else {
            this.canvas.setBackground(display.getSystemColor(1));
        }
        this.canvas.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                ClientCanvasTab.this.canvas.clear();
                ClientCanvasTab.this.fitErnieToCanvas();
            }
        });
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setLineWidth(ClientCanvasTab.this.currentLineWidth);
                e.gc.setLineCap(2);
                e.gc.setLineJoin(2);
                e.gc.setForeground(display.getSystemColor(ClientCanvasTab.this.currentColor));
                e.gc.setAlpha(ClientCanvasTab.this.alpha);
            }
        });
        this.canvas.addClientDrawListener(new ClientDrawListener(){

            public void receivedDrawing() {
                ClientCanvasTab.this.redoToolItem.setEnabled(ClientCanvasTab.this.canvas.hasRedo());
                ClientCanvasTab.this.undoToolItem.setEnabled(ClientCanvasTab.this.canvas.hasUndo());
                ClientCanvasTab.this.clearToolItem.setEnabled(ClientCanvasTab.this.canvas.hasUndo());
            }
        });
        this.canvas.redraw();
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                GC gc = event.gc;
                Color oldForeground = gc.getForeground();
                Color oldBackground = gc.getBackground();
                gc.setForeground(event.display.getSystemColor(2));
                gc.setBackground(event.display.getSystemColor(2));
                this.drawErnie(gc);
                gc.setForeground(oldForeground);
                gc.setBackground(oldBackground);
            }

            private void drawErnie(GC gc) {
                int oldLineWidth = ClientCanvasTab.this.currentLineWidth;
                gc.setLineWidth(8);
                gc.fillPolygon(this.transform(this.getHair(ERNIE)));
                gc.drawPolyline(this.transform(this.getNeck(ERNIE)));
                gc.fillPolygon(this.transform(this.getRightEye(ERNIE)));
                gc.fillPolygon(this.transform(this.getLeftEye(ERNIE)));
                gc.drawPolyline(this.transform(this.getMouth(ERNIE)));
                this.drawDots(gc, ERNIE);
                gc.setLineWidth(oldLineWidth);
            }

            private int[] getLeftEye(List<int[]> dotInfos) {
                return this.getDotsAsPoly(dotInfos, LEFT_EYE[0], LEFT_EYE[1]);
            }

            private int[] getRightEye(List<int[]> dotInfos) {
                return this.getDotsAsPoly(dotInfos, RIGHT_EYE[0], RIGHT_EYE[1]);
            }

            private int[] getNeck(List<int[]> dotInfos) {
                return this.getDotsAsPoly(dotInfos, NECK[0], NECK[1]);
            }

            private int[] getHair(List<int[]> dotInfos) {
                return this.getDotsAsPoly(dotInfos, HAIR[0], HAIR[1]);
            }

            private int[] getMouth(List<int[]> dotInfos) {
                return this.getDotsAsPoly(dotInfos, MOUTH[0], MOUTH[1]);
            }

            private boolean isAlreadyDrawn(int dotLable) {
                for (int[] interval : ALLREADY_DRAWN_SUBSETS) {
                    if (dotLable < interval[0] || dotLable > interval[1]) continue;
                    return true;
                }
                return false;
            }

            private int[] getDotsAsPoly(List<int[]> dotInfos, int startLable, int endLable) {
                List<int[]> dotInfoSubset = this.getDots(dotInfos, startLable, endLable);
                int[] coordSubset = new int[dotInfoSubset.size() * 2];
                int coordIndex = 0;
                for (int[] dotInfo : dotInfoSubset) {
                    coordSubset[coordIndex] = dotInfo[1];
                    coordSubset[coordIndex + 1] = dotInfo[2];
                    coordIndex += 2;
                }
                return coordSubset;
            }

            private List<int[]> getDots(List<int[]> dotInfos, int startLable, int endLable) {
                ArrayList<int[]> result = new ArrayList<int[]>();
                int currentLable = startLable;
                for (int[] dotInfo : dotInfos) {
                    int dotLable = dotInfo[0];
                    if (dotLable == currentLable) {
                        result.add(dotInfo);
                        ++currentLable;
                    }
                    if (currentLable > endLable) break;
                }
                return result;
            }

            private void drawDots(GC gc, List<int[]> dotInfos) {
                int dotLable = 0;
                for (int[] dotInfo : dotInfos) {
                    if (this.isAlreadyDrawn(dotInfo[0])) continue;
                    this.drawDot(gc, ++dotLable, dotInfo[1], dotInfo[2]);
                }
            }

            private void drawDot(GC gc, int dotLabel, int x, int y) {
                Point dot = this.transform(new Point(x, y));
                int lableInterval = 1;
                if (dotLabel % lableInterval == 0) {
                    Color oldBackground = gc.getBackground();
                    gc.setBackground(gc.getDevice().getSystemColor(1));
                    gc.drawString(Integer.toString(dotLabel), dot.x + 5, dot.y + 5);
                    gc.setBackground(oldBackground);
                }
                gc.fillOval(dot.x, dot.y, 5, 5);
            }

            Point transform(Point coord) {
                Point centerDelta = this.calculateCenterDelta();
                Point inTopLeft = this.translate(coord, -ClientCanvasTab.ernieMinima.x, -ClientCanvasTab.ernieMinima.y);
                Point scaledInTopLeft = this.scale(inTopLeft, scaleFactor);
                this.translate(scaledInTopLeft, centerDelta.x, centerDelta.y);
                return scaledInTopLeft;
            }

            Point scale(Point coord, float factor) {
                coord.x = (int)((float)coord.x * factor);
                coord.y = (int)((float)coord.y * factor);
                return coord;
            }

            Point translate(Point coord, int deltaX, int deltaY) {
                coord.x += deltaX;
                coord.y += deltaY;
                return coord;
            }

            int[] transform(int[] coords) {
                Point centerDelta = this.calculateCenterDelta();
                int[] inTopLeft = this.translate(coords, -ClientCanvasTab.ernieMinima.x, -ClientCanvasTab.ernieMinima.y);
                int[] scaledInTopLeft = this.scale(inTopLeft, scaleFactor);
                this.translate(scaledInTopLeft, centerDelta.x, centerDelta.y);
                return scaledInTopLeft;
            }

            Point calculateCenterDelta() {
                int canvasCenterX = ClientCanvasTab.this.canvas.getBounds().width / 2;
                int canvasCenterY = ClientCanvasTab.this.canvas.getBounds().height / 2;
                int ernieCenterX = (int)((float)(ClientCanvasTab.ernieDimensions.x / 2) * scaleFactor);
                int ernieCenterY = (int)((float)(ClientCanvasTab.ernieDimensions.y / 2) * scaleFactor);
                Point result = new Point(canvasCenterX - ernieCenterX, canvasCenterY - ernieCenterY);
                return result;
            }

            int[] scale(int[] coords, float factor) {
                int i = 0;
                while (i < coords.length) {
                    coords[i] = (int)((float)coords[i] * factor);
                    ++i;
                }
                return coords;
            }

            int[] translate(int[] coords, int deltaX, int deltaY) {
                int i = 0;
                while (i < coords.length) {
                    int n = i;
                    coords[n] = coords[n] + deltaX;
                    int n2 = i + 1;
                    coords[n2] = coords[n2] + deltaY;
                    i += 2;
                }
                return coords;
            }
        });
    }

    private void fitErnieToCanvas() {
        Rectangle bounds = this.canvas.getBounds();
        scaleFactor = bounds.width >= bounds.height ? (float)bounds.height / (float)ClientCanvasTab.ernieDimensions.y : (float)bounds.width / (float)ClientCanvasTab.ernieDimensions.x;
        this.canvas.redraw();
    }

    private static void determineErnieDimensions() {
        int minX = -1;
        int minY = -1;
        int maxX = 0;
        int maxY = 0;
        for (int[] dotInfo : ERNIE) {
            int x = dotInfo[1];
            int y = dotInfo[2];
            if (x > maxX) {
                maxX = x;
            }
            if (y > maxY) {
                maxY = y;
            }
            if (minX == -1 || x < minX) {
                minX = x;
            }
            if (minY != -1 && y >= minY) continue;
            minY = y;
        }
        ernieDimensions = new Point(maxX - minX, maxY - minY + 5);
        ernieMinima = new Point(minX, minY);
    }

    private static void addToErnie(int index, int x, int y) {
        ERNIE.add(new int[]{index, x, y});
    }

    private GridLayout createGridLayout(int cols, boolean equalWidth) {
        GridLayout layout = new GridLayout(cols, equalWidth);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        return layout;
    }
}

