/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class OpenInputDialogHandler
extends AbstractHandler {
    private static final String PARAM_ID_TITLE = "title";
    private static final String PARAM_ID_MESSAGE = "message";
    private static final String PARAM_ID_INITIAL_VALUE = "initialValue";
    private static final String PARAM_ID_CANCEL_RETURNS = "cancelReturns";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String title = event.getParameter(PARAM_ID_TITLE);
        String message = event.getParameter(PARAM_ID_MESSAGE);
        String initialValue = event.getParameter(PARAM_ID_INITIAL_VALUE);
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell shell = activeWindow != null ? activeWindow.getShell() : null;
        InputDialog dialog = new InputDialog(shell, title, message, initialValue, null);
        int returnCode = dialog.open();
        if (returnCode == 1) {
            String cancelReturns = event.getParameter(PARAM_ID_CANCEL_RETURNS);
            if (cancelReturns != null) {
                return cancelReturns;
            }
            throw new ExecutionException("dialog canceled");
        }
        return dialog.getValue();
    }
}

