/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.felix.resolver.Backlog;
import org.apache.felix.resolver.Candidates;
import org.apache.felix.resolver.DumbExecutor;
import org.apache.felix.resolver.Logger;
import org.apache.felix.resolver.PackageSpaces;
import org.apache.felix.resolver.Packages;
import org.apache.felix.resolver.PermutationType;
import org.apache.felix.resolver.ResolutionError;
import org.apache.felix.resolver.ResolveSession;
import org.apache.felix.resolver.Util;
import org.apache.felix.resolver.WireImpl;
import org.apache.felix.resolver.WrappedRequirement;
import org.apache.felix.resolver.WrappedResource;
import org.apache.felix.resolver.util.ArrayMap;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;
import org.osgi.service.resolver.HostedCapability;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.resolver.ResolveContext;
import org.osgi.service.resolver.Resolver;

public class ResolverImpl
implements Resolver {
    private final AccessControlContext m_acc = System.getSecurityManager() != null ? AccessController.getContext() : null;
    private final Logger m_logger;
    private final int m_parallelism;
    private final Executor m_executor;

    public ResolverImpl(Logger logger) {
        this(logger, Runtime.getRuntime().availableProcessors());
    }

    public ResolverImpl(Logger logger, int parallelism) {
        this.m_logger = logger;
        this.m_parallelism = parallelism;
        this.m_executor = null;
    }

    public ResolverImpl(Logger logger, Executor executor) {
        this.m_logger = logger;
        this.m_parallelism = -1;
        this.m_executor = executor;
    }

    @Override
    public Map<Resource, List<Wire>> resolve(ResolveContext rc) throws ResolutionException {
        if (this.m_executor != null) {
            return this.resolve(rc, this.m_executor);
        }
        if (this.m_parallelism > 1) {
            Map<Resource, List<Wire>> map;
            ExecutorService executor = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<ExecutorService>(){

                @Override
                public ExecutorService run() {
                    return Executors.newFixedThreadPool(ResolverImpl.this.m_parallelism);
                }
            }, this.m_acc) : Executors.newFixedThreadPool(this.m_parallelism);
            try {
                map = this.resolve(rc, executor);
            }
            catch (Throwable throwable) {
                if (System.getSecurityManager() != null) {
                    AccessController.doPrivileged(new PrivilegedAction<Void>(executor){
                        private final /* synthetic */ ExecutorService val$executor;
                        {
                            this.val$executor = executorService;
                        }

                        @Override
                        public Void run() {
                            this.val$executor.shutdownNow();
                            return null;
                        }
                    }, this.m_acc);
                } else {
                    executor.shutdownNow();
                }
                throw throwable;
            }
            if (System.getSecurityManager() != null) {
                AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */, this.m_acc);
            } else {
                executor.shutdownNow();
            }
            return map;
        }
        return this.resolve(rc, new DumbExecutor());
    }

    public Map<Resource, List<Wire>> resolve(ResolveContext rc, Executor executor) throws ResolutionException {
        ResolveSession session = ResolveSession.createSession(rc, executor, null, null, null, this.m_logger);
        return this.doResolve(session);
    }

    private Map<Resource, List<Wire>> doResolve(ResolveSession session) throws ResolutionException {
        boolean retry;
        Map<Resource, List<Wire>> wireMap = new HashMap<Resource, List<Wire>>();
        do {
            retry = false;
            try {
                this.getInitialCandidates(session);
                HashMap<Resource, ResolutionError> faultyResources = new HashMap<Resource, ResolutionError>();
                Candidates allCandidates = this.findValidCandidates(session, faultyResources);
                session.checkForCancel();
                if (session.getCurrentError() != null) {
                    Set resourceKeys = faultyResources.keySet();
                    retry = session.getOptionalResources().removeAll(resourceKeys);
                    for (Resource resource : resourceKeys) {
                        if (!session.invalidateRelatedResource(resource)) continue;
                        retry = true;
                    }
                    for (Map.Entry entry : faultyResources.entrySet()) {
                        this.m_logger.logUsesConstraintViolation((Resource)entry.getKey(), (ResolutionError)entry.getValue());
                    }
                    if (retry) continue;
                    throw session.getCurrentError().toException();
                }
                if (session.getMultipleCardCandidates() != null) {
                    allCandidates = session.getMultipleCardCandidates();
                }
                if (session.isDynamic()) {
                    wireMap = ResolverImpl.populateDynamicWireMap(session, wireMap, allCandidates);
                    continue;
                }
                for (Resource resource : allCandidates.getRootHosts().keySet()) {
                    if (!allCandidates.isPopulated(resource)) continue;
                    wireMap = ResolverImpl.populateWireMap(session, allCandidates.getWrappedHost(resource), wireMap, allCandidates);
                }
            }
            finally {
                session.clearPermutations();
            }
        } while (retry);
        return wireMap;
    }

    private void getInitialCandidates(ResolveSession session) throws ResolutionException {
        ResolutionError prepareError;
        Candidates initialCandidates;
        if (session.isDynamic()) {
            initialCandidates = new Candidates(session);
            prepareError = initialCandidates.populateDynamic();
            if (prepareError != null) {
                throw prepareError.toException();
            }
        } else {
            ArrayList<Resource> toPopulate = new ArrayList<Resource>();
            for (Resource resource : session.getMandatoryResources()) {
                if (!Util.isFragment(resource) && session.getContext().getWirings().get(resource) != null) continue;
                toPopulate.add(resource);
            }
            for (Resource resource : session.getOptionalResources()) {
                if (!Util.isFragment(resource) && session.getContext().getWirings().get(resource) != null) continue;
                toPopulate.add(resource);
            }
            initialCandidates = new Candidates(session);
            initialCandidates.populate(toPopulate);
        }
        if ((prepareError = initialCandidates.prepare()) != null) {
            throw prepareError.toException();
        }
        session.addPermutation(PermutationType.USES, initialCandidates);
    }

    private Candidates findValidCandidates(ResolveSession session, Map<Resource, ResolutionError> faultyResources) {
        Backlog backlog = new Backlog(session);
        Candidates current = Objects.requireNonNull(backlog.getNext());
        Candidates bestCandidate = null;
        ResolutionError bestError = null;
        Candidates.FaultyResourcesReport bestReport = null;
        HashMap<Resource, ResolutionError> bestFaultyResources = null;
        while (!session.isCancelled()) {
            Candidates next;
            HashMap<Resource, ResolutionError> currentFaultyResources = new HashMap<Resource, ResolutionError>();
            ResolutionError consistency = PackageSpaces.checkConsistency(session, current, currentFaultyResources, this.m_logger);
            session.setCurrentError(consistency);
            Candidates.FaultyResourcesReport report = current.getFaultyResources(currentFaultyResources);
            if (consistency == null && report.getUnresolvedRequirements().isEmpty()) {
                this.m_logger.logPermutationProcessed(null);
                break;
            }
            if (!(currentFaultyResources.isEmpty() || bestFaultyResources != null && currentFaultyResources.size() >= bestFaultyResources.size())) {
                bestFaultyResources = currentFaultyResources;
            }
            this.m_logger.logPermutationProcessed(consistency == null ? report : consistency);
            if (bestCandidate == null || report.isBetterThan(bestReport)) {
                bestCandidate = current;
                bestReport = report;
                bestError = consistency == null ? (report.isMissingMandatory() ? report : null) : consistency;
            }
            if ((next = backlog.getNext()) == null) {
                session.setCurrentError(bestError);
                if (bestFaultyResources != null) {
                    faultyResources.putAll(bestFaultyResources);
                }
                return bestCandidate;
            }
            current = next;
        }
        return current;
    }

    @Override
    public Map<Resource, List<Wire>> resolveDynamic(ResolveContext context, Wiring hostWiring, Requirement dynamicRequirement) throws ResolutionException {
        Resource host = hostWiring.getResource();
        List<Capability> matches = context.findProviders(dynamicRequirement);
        if (!matches.isEmpty()) {
            for (Capability cap : matches) {
                if (cap.getNamespace().equals("osgi.wiring.package")) continue;
                throw new IllegalArgumentException("Matching candidate does not provide a package name.");
            }
            ResolveSession session = ResolveSession.createSession(context, new DumbExecutor(), host, dynamicRequirement, matches, this.m_logger);
            return this.doResolve(session);
        }
        throw new Candidates.MissingRequirementError(dynamicRequirement).toException();
    }

    private static Resource getDeclaredResource(Resource resource) {
        if (resource instanceof WrappedResource) {
            return ((WrappedResource)resource).getDeclaredResource();
        }
        return resource;
    }

    private static Capability getDeclaredCapability(Capability c) {
        if (c instanceof HostedCapability) {
            return ((HostedCapability)c).getDeclaredCapability();
        }
        return c;
    }

    static Requirement getDeclaredRequirement(Requirement r) {
        if (r instanceof WrappedRequirement) {
            return ((WrappedRequirement)r).getDeclaredRequirement();
        }
        return r;
    }

    private static Map<Resource, List<Wire>> populateWireMap(ResolveSession session, Resource resource, Map<Resource, List<Wire>> wireMap, Candidates allCandidates) {
        Resource unwrappedResource = ResolverImpl.getDeclaredResource(resource);
        if (!session.getContext().getWirings().containsKey(unwrappedResource) && !wireMap.containsKey(unwrappedResource)) {
            Wire wire;
            wireMap.put(unwrappedResource, Collections.emptyList());
            ArrayList<WireImpl> packageWires = new ArrayList<WireImpl>();
            ArrayList<WireImpl> bundleWires = new ArrayList<WireImpl>();
            ArrayList<WireImpl> capabilityWires = new ArrayList<WireImpl>();
            block0: for (Requirement req : resource.getRequirements(null)) {
                List<Capability> cands = allCandidates.getCandidates(req);
                if (cands == null || cands.size() <= 0) continue;
                for (Capability cand : cands) {
                    if (!cand.getNamespace().startsWith("osgi.wiring.") || !resource.equals(cand.getResource())) {
                        ResolverImpl.populateWireMap(session, cand.getResource(), wireMap, allCandidates);
                        Resource provider = req.getNamespace().equals("osgi.identity") ? ResolverImpl.getDeclaredCapability(cand).getResource() : ResolverImpl.getDeclaredResource(cand.getResource());
                        wire = new WireImpl(unwrappedResource, ResolverImpl.getDeclaredRequirement(req), provider, ResolverImpl.getDeclaredCapability(cand));
                        if (req.getNamespace().equals("osgi.wiring.package")) {
                            packageWires.add((WireImpl)wire);
                        } else if (req.getNamespace().equals("osgi.wiring.bundle")) {
                            bundleWires.add((WireImpl)wire);
                        } else {
                            capabilityWires.add((WireImpl)wire);
                        }
                    }
                    if (!Util.isMultiple(req)) continue block0;
                }
            }
            packageWires.addAll(bundleWires);
            packageWires.addAll(capabilityWires);
            wireMap.put(unwrappedResource, packageWires);
            if (resource instanceof WrappedResource) {
                List<Resource> fragments = ((WrappedResource)resource).getFragments();
                for (Resource fragment : fragments) {
                    ArrayList<WireImpl> fragmentWires = wireMap.get(fragment);
                    fragmentWires = fragmentWires == null ? new ArrayList<WireImpl>() : fragmentWires;
                    for (Requirement req : fragment.getRequirements(null)) {
                        if (ResolverImpl.isPayload(req)) continue;
                        if (req.getNamespace().equals("osgi.wiring.host")) {
                            fragmentWires.add(new WireImpl(ResolverImpl.getDeclaredResource(fragment), req, unwrappedResource, unwrappedResource.getCapabilities("osgi.wiring.host").get(0)));
                            continue;
                        }
                        if (session.getContext().getWirings().containsKey(fragment) || wireMap.containsKey(fragment) || (wire = ResolverImpl.createWire(req, allCandidates)) == null) continue;
                        fragmentWires.add((WireImpl)wire);
                    }
                    wireMap.put(fragment, fragmentWires);
                }
            }
            for (Resource related : session.getRelatedResources(unwrappedResource)) {
                if (!allCandidates.isPopulated(related)) continue;
                ResolverImpl.populateWireMap(session, related, wireMap, allCandidates);
            }
        }
        return wireMap;
    }

    private static Wire createWire(Requirement requirement, Candidates allCandidates) {
        Capability cand = allCandidates.getFirstCandidate(requirement);
        if (cand == null) {
            return null;
        }
        return new WireImpl(ResolverImpl.getDeclaredResource(requirement.getResource()), ResolverImpl.getDeclaredRequirement(requirement), ResolverImpl.getDeclaredResource(cand.getResource()), ResolverImpl.getDeclaredCapability(cand));
    }

    private static boolean isPayload(Requirement fragmentReq) {
        if ("osgi.ee".equals(fragmentReq.getNamespace())) {
            return false;
        }
        return !"osgi.wiring.host".equals(fragmentReq.getNamespace());
    }

    private static Map<Resource, List<Wire>> populateDynamicWireMap(ResolveSession session, Map<Resource, List<Wire>> wireMap, Candidates allCandidates) {
        wireMap.put(session.getDynamicHost(), Collections.emptyList());
        ArrayList<WireImpl> packageWires = new ArrayList<WireImpl>();
        Capability dynCand = allCandidates.getFirstCandidate(session.getDynamicRequirement());
        if (!session.getContext().getWirings().containsKey(dynCand.getResource())) {
            ResolverImpl.populateWireMap(session, dynCand.getResource(), wireMap, allCandidates);
        }
        packageWires.add(new WireImpl(session.getDynamicHost(), session.getDynamicRequirement(), ResolverImpl.getDeclaredResource(dynCand.getResource()), ResolverImpl.getDeclaredCapability(dynCand)));
        wireMap.put(session.getDynamicHost(), packageWires);
        return wireMap;
    }

    private static void dumpResourcePkgMap(ResolveContext rc, Map<Resource, Packages> resourcePkgMap) {
        System.out.println("+++RESOURCE PKG MAP+++");
        for (Map.Entry<Resource, Packages> entry : resourcePkgMap.entrySet()) {
            ResolverImpl.dumpResourcePkgs(rc, entry.getKey(), entry.getValue());
        }
    }

    private static void dumpResourcePkgs(ResolveContext rc, Resource resource, Packages packages) {
        Wiring wiring = rc.getWirings().get(resource);
        System.out.println(resource + " (" + (wiring != null ? "RESOLVED)" : "UNRESOLVED)"));
        System.out.println("  EXPORTED");
        for (Map.Entry entry : packages.m_exportedPkgs.entrySet()) {
            System.out.println("    " + (String)entry.getKey() + " - " + entry.getValue());
        }
        System.out.println("  IMPORTED");
        for (Map.Entry entry : packages.m_importedPkgs.entrySet()) {
            System.out.println("    " + (String)entry.getKey() + " - " + entry.getValue());
        }
        System.out.println("  REQUIRED");
        for (Map.Entry entry : packages.m_requiredPkgs.entrySet()) {
            System.out.println("    " + (String)entry.getKey() + " - " + entry.getValue());
        }
        System.out.println("  USED");
        for (Map.Entry entry : packages.m_usedPkgs.entrySet()) {
            System.out.println("    " + (String)entry.getKey() + " - " + ((ArrayMap)entry.getValue()).values());
        }
    }
}

