/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.http.servlet.internal.context;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextAttributeListener;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequestAttributeListener;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionAttributeListener;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionIdListener;
import jakarta.servlet.http.HttpSessionListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.rap.http.servlet.dto.ExtendedServletDTO;
import org.eclipse.rap.http.servlet.internal.HttpServiceRuntimeImpl;
import org.eclipse.rap.http.servlet.internal.context.DispatchTargets;
import org.eclipse.rap.http.servlet.internal.context.ProxyContext;
import org.eclipse.rap.http.servlet.internal.context.ServiceHolder;
import org.eclipse.rap.http.servlet.internal.customizer.ContextErrorPageTrackerCustomizer;
import org.eclipse.rap.http.servlet.internal.customizer.ContextFilterTrackerCustomizer;
import org.eclipse.rap.http.servlet.internal.customizer.ContextListenerTrackerCustomizer;
import org.eclipse.rap.http.servlet.internal.customizer.ContextResourceTrackerCustomizer;
import org.eclipse.rap.http.servlet.internal.customizer.ContextServletTrackerCustomizer;
import org.eclipse.rap.http.servlet.internal.dto.ExtendedErrorPageDTO;
import org.eclipse.rap.http.servlet.internal.error.HttpWhiteboardFailureException;
import org.eclipse.rap.http.servlet.internal.error.IllegalContextNameException;
import org.eclipse.rap.http.servlet.internal.error.IllegalContextPathException;
import org.eclipse.rap.http.servlet.internal.registration.EndpointRegistration;
import org.eclipse.rap.http.servlet.internal.registration.ErrorPageRegistration;
import org.eclipse.rap.http.servlet.internal.registration.FilterRegistration;
import org.eclipse.rap.http.servlet.internal.registration.ListenerRegistration;
import org.eclipse.rap.http.servlet.internal.registration.ResourceRegistration;
import org.eclipse.rap.http.servlet.internal.registration.ServletRegistration;
import org.eclipse.rap.http.servlet.internal.servlet.FilterConfigImpl;
import org.eclipse.rap.http.servlet.internal.servlet.HttpSessionAdaptor;
import org.eclipse.rap.http.servlet.internal.servlet.Match;
import org.eclipse.rap.http.servlet.internal.servlet.ResourceServlet;
import org.eclipse.rap.http.servlet.internal.servlet.ServletConfigImpl;
import org.eclipse.rap.http.servlet.internal.servlet.ServletContextAdaptor;
import org.eclipse.rap.http.servlet.internal.util.DTOUtil;
import org.eclipse.rap.http.servlet.internal.util.EventListeners;
import org.eclipse.rap.http.servlet.internal.util.Path;
import org.eclipse.rap.http.servlet.internal.util.ServiceProperties;
import org.eclipse.rap.http.servlet.internal.util.StringPlus;
import org.eclipse.rap.http.servlet.internal.util.Throw;
import org.eclipse.rap.service.servlet.internal.context.ServletContextHelper;
import org.eclipse.rap.service.servlet.internal.runtime.dto.ErrorPageDTO;
import org.eclipse.rap.service.servlet.internal.runtime.dto.FailedErrorPageDTO;
import org.eclipse.rap.service.servlet.internal.runtime.dto.FailedResourceDTO;
import org.eclipse.rap.service.servlet.internal.runtime.dto.FailedServletDTO;
import org.eclipse.rap.service.servlet.internal.runtime.dto.FilterDTO;
import org.eclipse.rap.service.servlet.internal.runtime.dto.ListenerDTO;
import org.eclipse.rap.service.servlet.internal.runtime.dto.RequestInfoDTO;
import org.eclipse.rap.service.servlet.internal.runtime.dto.ResourceDTO;
import org.eclipse.rap.service.servlet.internal.runtime.dto.ServletContextDTO;
import org.eclipse.rap.service.servlet.internal.runtime.dto.ServletDTO;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ContextController {
    private static final String[] DISPATCHER = new String[]{DispatcherType.REQUEST.toString()};
    private static final String SIMPLE_NAME = ContextController.class.getSimpleName();
    private static final Pattern contextNamePattern = Pattern.compile("^([a-zA-Z_0-9\\-]+\\.)*[a-zA-Z_0-9\\-]+$");
    private final Map<String, String> initParams;
    private final BundleContext trackingContext;
    private final BundleContext consumingContext;
    private final String contextName;
    private final String contextPath;
    private volatile String fullContextPath;
    private final long contextServiceId;
    private final Set<EndpointRegistration<?>> endpointRegistrations = new ConcurrentSkipListSet();
    private final EventListeners eventListeners = new EventListeners();
    private final Set<FilterRegistration> filterRegistrations = new ConcurrentSkipListSet<FilterRegistration>();
    private final ConcurrentMap<String, HttpSessionAdaptor> activeSessions = new ConcurrentHashMap<String, HttpSessionAdaptor>();
    private final HttpServiceRuntimeImpl httpServiceRuntime;
    private final Set<ListenerRegistration> listenerRegistrations = new HashSet<ListenerRegistration>();
    private final ProxyContext proxyContext;
    private final ServiceReference<ServletContextHelper> serviceReference;
    private final String servletContextHelperRefFilter;
    private boolean shutdown;
    private String string;
    private final ServiceTracker<Servlet, AtomicReference<ErrorPageRegistration>> errorPageServiceTracker;
    private final ServiceTracker<jakarta.servlet.Filter, AtomicReference<FilterRegistration>> filterServiceTracker;
    private final ServiceTracker<EventListener, AtomicReference<ListenerRegistration>> listenerServiceTracker;
    private final ServiceTracker<Object, AtomicReference<ResourceRegistration>> resourceServiceTracker;
    private final ServiceTracker<Servlet, AtomicReference<ServletRegistration>> servletServiceTracker;

    public ContextController(BundleContext trackingContextParam, BundleContext consumingContext, ServiceReference<ServletContextHelper> serviceReference, ServletContext parentServletContext, HttpServiceRuntimeImpl httpServiceRuntime) {
        this.trackingContext = trackingContextParam;
        this.consumingContext = consumingContext;
        this.serviceReference = serviceReference;
        this.httpServiceRuntime = httpServiceRuntime;
        this.contextName = this.validateName();
        this.contextPath = this.validatePath();
        this.proxyContext = new ProxyContext(this.contextName, parentServletContext);
        this.contextServiceId = (Long)serviceReference.getProperty("service.id");
        this.servletContextHelperRefFilter = ContextController.createFilter(this.contextServiceId);
        this.initParams = ServiceProperties.parseInitParams(serviceReference, "context.init.", parentServletContext);
        this.listenerServiceTracker = new ServiceTracker(this.trackingContext, httpServiceRuntime.getListenerFilter(), (ServiceTrackerCustomizer)new ContextListenerTrackerCustomizer(this.trackingContext, httpServiceRuntime, this));
        this.listenerServiceTracker.open();
        this.filterServiceTracker = new ServiceTracker(this.trackingContext, httpServiceRuntime.getFilterFilter(), (ServiceTrackerCustomizer)new ContextFilterTrackerCustomizer(this.trackingContext, httpServiceRuntime, this));
        this.filterServiceTracker.open();
        this.errorPageServiceTracker = new ServiceTracker(this.trackingContext, httpServiceRuntime.getErrorPageFilter(), (ServiceTrackerCustomizer)new ContextErrorPageTrackerCustomizer(this.trackingContext, httpServiceRuntime, this));
        this.errorPageServiceTracker.open();
        this.servletServiceTracker = new ServiceTracker(this.trackingContext, httpServiceRuntime.getServletFilter(), (ServiceTrackerCustomizer)new ContextServletTrackerCustomizer(this.trackingContext, httpServiceRuntime, this));
        this.servletServiceTracker.open();
        this.resourceServiceTracker = new ServiceTracker(this.trackingContext, httpServiceRuntime.getResourceFilter(), (ServiceTrackerCustomizer)new ContextResourceTrackerCustomizer(this.trackingContext, httpServiceRuntime, this));
        this.resourceServiceTracker.open();
    }

    public ErrorPageRegistration addErrorPageRegistration(ServiceReference<Servlet> servletRef) {
        ServiceHolder<Servlet> servletHolder = new ServiceHolder<Servlet>(this.consumingContext.getServiceObjects(servletRef));
        Servlet servlet = (Servlet)servletHolder.get();
        ErrorPageRegistration registration = null;
        try {
            if (servlet == null) {
                throw new IllegalArgumentException("Servlet cannot be null");
            }
            registration = this.doAddErrorPageRegistration(servletHolder, servletRef);
        }
        finally {
            if (registration == null) {
                servletHolder.release();
            }
        }
        return registration;
    }

    private ErrorPageRegistration doAddErrorPageRegistration(ServiceHolder<Servlet> servletHolder, ServiceReference<Servlet> servletRef) {
        ExtendedErrorPageDTO errorPageDTO = DTOUtil.assembleErrorPageDTO(servletRef, this.getServiceId(), true);
        errorPageDTO.servletInfo = servletHolder.get().getServletInfo();
        errorPageDTO.serviceId = servletHolder.getServiceId();
        if (!(errorPageDTO.errorCodes != null && errorPageDTO.errorCodes.length != 0 || errorPageDTO.exceptions != null && errorPageDTO.exceptions.length != 0)) {
            throw new HttpWhiteboardFailureException("'errorPage' expects String, String[] or Collection<String>.", 6);
        }
        if (errorPageDTO.name == null) {
            errorPageDTO.name = servletHolder.get().getClass().getName();
        }
        ServletContextHelper curServletContextHelper = this.getServletContextHelper(servletHolder.getBundle());
        ServletContext servletContext = this.createServletContext(servletHolder.getBundle(), curServletContextHelper);
        ErrorPageRegistration errorPageRegistration = new ErrorPageRegistration(servletHolder, errorPageDTO, curServletContextHelper, this);
        ServletConfigImpl servletConfig = new ServletConfigImpl(errorPageDTO.name, errorPageDTO.initParams, servletContext);
        try {
            errorPageRegistration.init(servletConfig);
        }
        catch (Throwable t) {
            errorPageRegistration.destroy();
            return (ErrorPageRegistration)Throw.unchecked(t);
        }
        this.recordErrorPageShadowing(errorPageRegistration);
        this.endpointRegistrations.add(errorPageRegistration);
        return errorPageRegistration;
    }

    public FilterRegistration addFilterRegistration(ServiceReference<jakarta.servlet.Filter> filterRef) throws ServletException {
        ServiceHolder<jakarta.servlet.Filter> filterHolder = new ServiceHolder<jakarta.servlet.Filter>(this.consumingContext.getServiceObjects(filterRef));
        jakarta.servlet.Filter filter = (jakarta.servlet.Filter)filterHolder.get();
        FilterRegistration registration = null;
        boolean addedRegisteredObject = false;
        try {
            if (filter == null) {
                throw new IllegalArgumentException("Filter cannot be null");
            }
            addedRegisteredObject = this.httpServiceRuntime.getRegisteredObjects().add(filter);
            if (!addedRegisteredObject) {
                throw new HttpWhiteboardFailureException("Multiple registration of instance detected. Prototype scope is recommended: " + String.valueOf(filterRef), 7);
            }
            registration = this.doAddFilterRegistration(filterHolder, filterRef);
        }
        finally {
            if (registration == null) {
                filterHolder.release();
                if (addedRegisteredObject) {
                    this.httpServiceRuntime.getRegisteredObjects().remove(filter);
                }
            }
        }
        return registration;
    }

    private FilterRegistration doAddFilterRegistration(ServiceHolder<jakarta.servlet.Filter> filterHolder, ServiceReference<jakarta.servlet.Filter> filterRef) throws ServletException {
        int n;
        int n2;
        String[] stringArray;
        boolean asyncSupported = ServiceProperties.parseBoolean(filterRef, "osgi.http.whiteboard.filter.asyncSupported");
        List<String> dispatcherList = StringPlus.from(filterRef.getProperty("osgi.http.whiteboard.filter.dispatcher"));
        String[] dispatchers = dispatcherList.toArray(new String[0]);
        Integer filterPriority = (Integer)filterRef.getProperty("service.ranking");
        if (filterPriority == null) {
            filterPriority = 0;
        }
        Map<String, String> filterInitParams = ServiceProperties.parseInitParams(filterRef, "filter.init.");
        List<String> patternList = StringPlus.from(filterRef.getProperty("osgi.http.whiteboard.filter.pattern"));
        String[] patterns = patternList.toArray(new String[0]);
        List<String> regexList = StringPlus.from(filterRef.getProperty("osgi.http.whiteboard.filter.regex"));
        String[] regexs = regexList.toArray(new String[0]);
        List<String> servletList = StringPlus.from(filterRef.getProperty("osgi.http.whiteboard.filter.servlet"));
        String[] servletNames = servletList.toArray(new String[0]);
        String name = ServiceProperties.parseName(filterRef.getProperty("osgi.http.whiteboard.filter.name"), filterHolder.get());
        if (!(patterns != null && patterns.length != 0 || regexs != null && regexs.length != 0 || servletNames != null && servletNames.length != 0)) {
            throw new HttpWhiteboardFailureException("Patterns, regex or servletNames must contain a value.", 6);
        }
        if (patterns != null) {
            stringArray = patterns;
            n2 = patterns.length;
            n = 0;
            while (n < n2) {
                String pattern = stringArray[n];
                ContextController.checkPattern(pattern);
                ++n;
            }
        }
        if (regexs != null) {
            stringArray = regexs;
            n2 = regexs.length;
            n = 0;
            while (n < n2) {
                String regex = stringArray[n];
                ContextController.checkRegex(regex);
                ++n;
            }
        }
        jakarta.servlet.Filter filter = filterHolder.get();
        if (name == null) {
            name = filter.getClass().getName();
        }
        dispatchers = this.checkDispatcher(dispatchers);
        FilterDTO filterDTO = new FilterDTO();
        filterDTO.asyncSupported = asyncSupported;
        filterDTO.dispatcher = this.sort(dispatchers);
        filterDTO.initParams = filterInitParams;
        filterDTO.name = name;
        filterDTO.patterns = this.sort(patterns);
        filterDTO.regexs = regexs;
        filterDTO.serviceId = filterHolder.getServiceId();
        filterDTO.servletContextId = this.contextServiceId;
        filterDTO.servletNames = this.sort(servletNames);
        ServletContextHelper curServletContextHelper = this.getServletContextHelper(filterHolder.getBundle());
        ServletContext servletContext = this.createServletContext(filterHolder.getBundle(), curServletContextHelper);
        FilterRegistration newRegistration = new FilterRegistration(filterHolder, filterDTO, filterPriority, this);
        FilterConfigImpl filterConfig = new FilterConfigImpl(name, filterInitParams, servletContext);
        newRegistration.init(filterConfig);
        this.filterRegistrations.add(newRegistration);
        return newRegistration;
    }

    public ListenerRegistration addListenerRegistration(ServiceReference<EventListener> listenerRef) throws ServletException {
        ServiceHolder<EventListener> listenerHolder = new ServiceHolder<EventListener>(this.consumingContext.getServiceObjects(listenerRef));
        EventListener listener = (EventListener)listenerHolder.get();
        ListenerRegistration registration = null;
        try {
            if (listener == null) {
                throw new IllegalArgumentException("EventListener cannot be null");
            }
            registration = this.doAddListenerRegistration(listenerHolder, listenerRef);
        }
        finally {
            if (registration == null) {
                listenerHolder.release();
            }
        }
        return registration;
    }

    private ListenerRegistration doAddListenerRegistration(ServiceHolder<EventListener> listenerHolder, ServiceReference<EventListener> listenerRef) throws ServletException {
        EventListener eventListener = listenerHolder.get();
        List<Class<? extends EventListener>> classes = this.getListenerClasses(listenerRef);
        if (classes.isEmpty()) {
            throw new IllegalArgumentException("EventListener does not implement a supported type.");
        }
        for (ListenerRegistration listenerRegistration : this.listenerRegistrations) {
            if (!listenerRegistration.getT().equals(eventListener)) continue;
            throw new ServletException("EventListener has already been registered.");
        }
        ListenerDTO listenerDTO = new ListenerDTO();
        listenerDTO.serviceId = listenerHolder.getServiceId();
        listenerDTO.servletContextId = this.contextServiceId;
        listenerDTO.types = this.asStringArray(classes);
        ServletContextHelper curServletContextHelper = this.getServletContextHelper(listenerHolder.getBundle());
        ServletContext servletContext = this.createServletContext(listenerHolder.getBundle(), curServletContextHelper);
        ListenerRegistration listenerRegistration = new ListenerRegistration(listenerHolder, classes, listenerDTO, servletContext, this);
        if (classes.contains(ServletContextListener.class)) {
            ServletContextListener servletContextListener = (ServletContextListener)listenerRegistration.getT();
            servletContextListener.contextInitialized(new ServletContextEvent(servletContext));
        }
        this.listenerRegistrations.add(listenerRegistration);
        this.eventListeners.put(classes, listenerRegistration);
        return listenerRegistration;
    }

    public ResourceRegistration addResourceRegistration(ServiceReference<?> resourceRef) {
        ClassLoader legacyTCCL = (ClassLoader)resourceRef.getProperty("equinox.legacy.tccl");
        Integer rankProp = (Integer)resourceRef.getProperty("service.ranking");
        int serviceRanking = rankProp == null ? 0 : rankProp;
        Object patternObj = resourceRef.getProperty("osgi.http.whiteboard.resource.pattern");
        if (!(patternObj instanceof String || patternObj instanceof String[] || patternObj instanceof Collection)) {
            throw new HttpWhiteboardFailureException("Expect pattern to be String+ (String | String[] | Collection<String>)", 6);
        }
        List<String> patternList = StringPlus.from(patternObj);
        String[] patterns = patternList.toArray(new String[0]);
        Long serviceId = (Long)resourceRef.getProperty("service.id");
        if (legacyTCCL != null) {
            serviceId = -serviceId.longValue();
        }
        Object prefixObj = resourceRef.getProperty("osgi.http.whiteboard.resource.prefix");
        ContextController.checkPrefix(prefixObj);
        String prefix = (String)prefixObj;
        if (patterns == null || patterns.length < 1) {
            throw new IllegalArgumentException("Patterns must contain a value.");
        }
        String[] stringArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            ContextController.checkPattern(pattern);
            ++n2;
        }
        Bundle bundle = resourceRef.getBundle();
        ServletContextHelper curServletContextHelper = this.getServletContextHelper(bundle);
        ResourceServlet servlet = new ResourceServlet(prefix, curServletContextHelper, AccessController.getContext());
        ResourceDTO resourceDTO = new ResourceDTO();
        resourceDTO.patterns = this.sort(patterns);
        resourceDTO.prefix = prefix;
        resourceDTO.serviceId = serviceId;
        resourceDTO.servletContextId = this.contextServiceId;
        ServletContext servletContext = this.createServletContext(bundle, curServletContextHelper);
        ResourceRegistration resourceRegistration = new ResourceRegistration(resourceRef, new ServiceHolder<ResourceServlet>(servlet, bundle, serviceId, serviceRanking, legacyTCCL), resourceDTO, curServletContextHelper, this);
        ServletConfigImpl servletConfig = new ServletConfigImpl(resourceRegistration.getName(), new HashMap<String, String>(), servletContext);
        try {
            resourceRegistration.init(servletConfig);
        }
        catch (Throwable t) {
            resourceRegistration.destroy();
            return (ResourceRegistration)Throw.unchecked(t);
        }
        this.recordEndpointShadowing(resourceRegistration);
        this.endpointRegistrations.add(resourceRegistration);
        return resourceRegistration;
    }

    public ServletRegistration addServletRegistration(ServiceReference<Servlet> servletRef) {
        ServiceHolder<Servlet> servletHolder = new ServiceHolder<Servlet>(this.consumingContext.getServiceObjects(servletRef));
        Servlet servlet = (Servlet)servletHolder.get();
        ServletRegistration registration = null;
        boolean addedRegisteredObject = false;
        try {
            if (servlet == null) {
                throw new IllegalArgumentException("Servlet cannot be null");
            }
            addedRegisteredObject = this.httpServiceRuntime.getRegisteredObjects().add(servlet);
            if (!addedRegisteredObject) {
                throw new HttpWhiteboardFailureException("Multiple registration of instance detected. Prototype scope is recommended: " + String.valueOf(servletRef), 7);
            }
            registration = this.doAddServletRegistration(servletHolder, servletRef);
        }
        finally {
            if (registration == null) {
                servletHolder.release();
                if (addedRegisteredObject) {
                    this.httpServiceRuntime.getRegisteredObjects().remove(servlet);
                }
            }
        }
        return registration;
    }

    private ServletRegistration doAddServletRegistration(ServiceHolder<Servlet> servletHolder, ServiceReference<Servlet> servletRef) {
        ExtendedServletDTO servletDTO = DTOUtil.assembleServletDTO(servletRef, this.getServiceId(), true);
        servletDTO.servletInfo = servletHolder.get().getServletInfo();
        servletDTO.serviceId = servletHolder.getServiceId();
        if ((servletDTO.patterns == null || servletDTO.patterns.length == 0) && servletDTO.name == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("One of the service properties ");
            sb.append("osgi.http.whiteboard.servlet.name");
            sb.append(", ");
            sb.append("osgi.http.whiteboard.servlet.pattern");
            sb.append(" must contain a value.");
            throw new HttpWhiteboardFailureException(sb.toString(), 6);
        }
        if (servletDTO.name == null) {
            servletDTO.name = servletHolder.get().getClass().getName();
        }
        ServletContextHelper curServletContextHelper = this.getServletContextHelper(servletHolder.getBundle());
        ServletContext servletContext = this.createServletContext(servletHolder.getBundle(), curServletContextHelper);
        ServletRegistration servletRegistration = new ServletRegistration(servletHolder, servletDTO, curServletContextHelper, this, servletContext);
        ServletConfigImpl servletConfig = new ServletConfigImpl(servletDTO.name, servletDTO.initParams, servletContext);
        try {
            servletRegistration.init(servletConfig);
        }
        catch (Throwable t) {
            servletRegistration.destroy();
            return (ServletRegistration)Throw.unchecked(t);
        }
        this.recordEndpointShadowing(servletRegistration);
        this.endpointRegistrations.add(servletRegistration);
        return servletRegistration;
    }

    private void recordEndpointShadowing(EndpointRegistration<?> newRegistration) {
        HashSet shadowedRegs = new HashSet();
        for (EndpointRegistration<?> endpointRegistration : this.endpointRegistrations) {
            String[] stringArray = newRegistration.getPatterns();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String newPattern = stringArray[n2];
                String[] stringArray2 = endpointRegistration.getPatterns();
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String existingPattern = stringArray2[n4];
                    if (newPattern.equals(existingPattern)) {
                        if (newRegistration.compareTo(endpointRegistration) < 0) {
                            shadowedRegs.add(endpointRegistration);
                        } else {
                            shadowedRegs.add(newRegistration);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        for (EndpointRegistration<Object> endpointRegistration : shadowedRegs) {
            if (endpointRegistration instanceof ServletRegistration) {
                this.recordFailedServletDTO(endpointRegistration.getServiceReference(), (ServletDTO)((Object)endpointRegistration.getD()), 3);
                continue;
            }
            this.recordFailedResourceDTO(endpointRegistration.getServiceReference(), (ResourceDTO)((Object)endpointRegistration.getD()), 3);
        }
    }

    private void recordErrorPageShadowing(ErrorPageRegistration newRegistration) {
        HashSet<ErrorPageRegistration> shadowedEPs = new HashSet<ErrorPageRegistration>();
        for (EndpointRegistration<?> existingRegistration : this.endpointRegistrations) {
            ErrorPageRegistration existingSRegistration;
            ExtendedErrorPageDTO existingErrorPageDTO;
            if (!(existingRegistration instanceof ErrorPageRegistration) || (existingErrorPageDTO = (ExtendedErrorPageDTO)((Object)(existingSRegistration = (ErrorPageRegistration)existingRegistration).getD())) == null || (existingErrorPageDTO.errorCodeType == ExtendedErrorPageDTO.ErrorCodeType.RANGE_4XX || existingErrorPageDTO.errorCodeType == ExtendedErrorPageDTO.ErrorCodeType.RANGE_5XX) && ((ExtendedErrorPageDTO)((Object)newRegistration.getD())).errorCodeType == ExtendedErrorPageDTO.ErrorCodeType.SPECIFIC) continue;
            if (existingErrorPageDTO.errorCodeType == ExtendedErrorPageDTO.ErrorCodeType.RANGE_4XX && ((ExtendedErrorPageDTO)((Object)newRegistration.getD())).errorCodeType == ExtendedErrorPageDTO.ErrorCodeType.RANGE_4XX || existingErrorPageDTO.errorCodeType == ExtendedErrorPageDTO.ErrorCodeType.RANGE_5XX && ((ExtendedErrorPageDTO)((Object)newRegistration.getD())).errorCodeType == ExtendedErrorPageDTO.ErrorCodeType.RANGE_5XX) {
                if (newRegistration.compareTo(existingSRegistration) < 0) {
                    shadowedEPs.add(existingSRegistration);
                    continue;
                }
                shadowedEPs.add(newRegistration);
                continue;
            }
            long[] lArray = ((ExtendedErrorPageDTO)((Object)((Object)newRegistration.getD()))).errorCodes;
            int n = ((ExtendedErrorPageDTO)((Object)((Object)newRegistration.getD()))).errorCodes.length;
            int n2 = 0;
            while (n2 < n) {
                long newErrorCode = lArray[n2];
                long[] lArray2 = existingErrorPageDTO.errorCodes;
                int n3 = existingErrorPageDTO.errorCodes.length;
                int n4 = 0;
                while (n4 < n3) {
                    long existingCode = lArray2[n4];
                    if (newErrorCode == existingCode) {
                        if (newRegistration.compareTo(existingSRegistration) < 0) {
                            shadowedEPs.add(existingSRegistration);
                        } else {
                            shadowedEPs.add(newRegistration);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
            String[] stringArray = ((ExtendedErrorPageDTO)((Object)((Object)newRegistration.getD()))).exceptions;
            n2 = ((ExtendedErrorPageDTO)((Object)((Object)newRegistration.getD()))).exceptions.length;
            int n5 = 0;
            while (n5 < n2) {
                String newException = stringArray[n5];
                String[] stringArray2 = existingErrorPageDTO.exceptions;
                int n6 = existingErrorPageDTO.exceptions.length;
                int n7 = 0;
                while (n7 < n6) {
                    String existingException = stringArray2[n7];
                    if (newException.equals(existingException)) {
                        if (newRegistration.compareTo(existingSRegistration) < 0) {
                            shadowedEPs.add(existingSRegistration);
                        } else {
                            shadowedEPs.add(newRegistration);
                        }
                    }
                    ++n7;
                }
                ++n5;
            }
        }
        for (ErrorPageRegistration shadowedReg : shadowedEPs) {
            this.recordFailedErrorPageDTO(shadowedReg.getServiceReference(), (ExtendedErrorPageDTO)((Object)shadowedReg.getD()), 3);
        }
    }

    public synchronized void destroy() {
        this.flushActiveSessions();
        this.resourceServiceTracker.close();
        this.servletServiceTracker.close();
        this.errorPageServiceTracker.close();
        this.filterServiceTracker.close();
        this.listenerServiceTracker.close();
        this.endpointRegistrations.clear();
        this.filterRegistrations.clear();
        this.listenerRegistrations.clear();
        this.eventListeners.clear();
        this.proxyContext.destroy();
        this.shutdown = true;
    }

    public void createContextAttributes() {
        this.getProxyContext().createContextAttributes(this);
    }

    public void destroyContextAttributes() {
        if (this.shutdown) {
            return;
        }
        this.proxyContext.destroyContextAttributes(this);
    }

    public boolean isLegacyContext() {
        return this.serviceReference.getProperty("osgi.http.whiteboard.context.httpservice") != null;
    }

    public String getContextName() {
        return this.contextName;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public DispatchTargets getDispatchTargets(String pathString, RequestInfoDTO requestInfoDTO) {
        Path path = new Path(pathString);
        String queryString = path.getQueryString();
        String requestURI = path.getRequestURI();
        DispatchTargets dispatchTargets = this.getDispatchTargets(requestURI, null, queryString, Match.EXACT, requestInfoDTO);
        if (dispatchTargets == null) {
            dispatchTargets = this.getDispatchTargets(requestURI, path.getExtension(), queryString, Match.EXTENSION, requestInfoDTO);
        }
        if (dispatchTargets == null) {
            dispatchTargets = this.getDispatchTargets(requestURI, null, queryString, Match.REGEX, requestInfoDTO);
        }
        if (dispatchTargets == null) {
            dispatchTargets = this.getDispatchTargets(requestURI, null, queryString, Match.DEFAULT_SERVLET, requestInfoDTO);
        }
        return dispatchTargets;
    }

    private DispatchTargets getDispatchTargets(String requestURI, String extension, String queryString, Match match, RequestInfoDTO requestInfoDTO) {
        int pos = requestURI.lastIndexOf(47);
        String servletPath = requestURI;
        String pathInfo = null;
        if (match == Match.DEFAULT_SERVLET) {
            pathInfo = servletPath;
            servletPath = "/";
        }
        while (true) {
            DispatchTargets dispatchTargets;
            if ((dispatchTargets = this.getDispatchTargets(null, requestURI, servletPath, pathInfo, extension, queryString, match, requestInfoDTO)) != null) {
                return dispatchTargets;
            }
            if (match == Match.EXACT || pos <= -1) break;
            String newServletPath = requestURI.substring(0, pos);
            pathInfo = requestURI.substring(pos);
            servletPath = newServletPath;
            pos = servletPath.lastIndexOf(47);
        }
        return null;
    }

    public DispatchTargets getDispatchTargets(String servletName, String requestURI, String servletPath, String pathInfo, String extension, String queryString, Match match, RequestInfoDTO requestInfoDTO) {
        int x;
        this.checkShutdown();
        EndpointRegistration<?> endpointRegistration = null;
        for (EndpointRegistration<?> curEndpointRegistration : this.endpointRegistrations) {
            if (curEndpointRegistration.match(servletName, (String)servletPath, pathInfo, extension, match) == null) continue;
            endpointRegistration = curEndpointRegistration;
            break;
        }
        if (endpointRegistration == null) {
            return null;
        }
        if (match == Match.EXTENSION) {
            servletPath = (String)servletPath + pathInfo;
            pathInfo = null;
        }
        this.addEnpointRegistrationsToRequestInfo(endpointRegistration, requestInfoDTO);
        if (this.filterRegistrations.isEmpty()) {
            return new DispatchTargets(this, endpointRegistration, servletName, requestURI, (String)servletPath, pathInfo, queryString);
        }
        if (requestURI != null && (x = requestURI.lastIndexOf(46)) != -1) {
            extension = requestURI.substring(x + 1);
        }
        ArrayList<FilterRegistration> matchingFilterRegistrations = new ArrayList<FilterRegistration>();
        this.collectFilters(matchingFilterRegistrations, endpointRegistration.getName(), requestURI, (String)servletPath, pathInfo, extension);
        this.addFilterRegistrationsToRequestInfo(matchingFilterRegistrations, requestInfoDTO);
        return new DispatchTargets(this, endpointRegistration, matchingFilterRegistrations, servletName, requestURI, (String)servletPath, pathInfo, queryString);
    }

    private void collectFilters(List<FilterRegistration> matchingFilterRegistrations, String servletName, String requestURI, String servletPath, String pathInfo, String extension) {
        for (FilterRegistration filterRegistration : this.filterRegistrations) {
            if (filterRegistration.match(servletName, requestURI, extension, null) == null || matchingFilterRegistrations.contains(filterRegistration)) continue;
            matchingFilterRegistrations.add(filterRegistration);
        }
    }

    public Map<String, HttpSessionAdaptor> getActiveSessions() {
        return this.activeSessions;
    }

    public Set<EndpointRegistration<?>> getEndpointRegistrations() {
        return this.endpointRegistrations;
    }

    public EventListeners getEventListeners() {
        return this.eventListeners;
    }

    public Set<FilterRegistration> getFilterRegistrations() {
        return this.filterRegistrations;
    }

    public String getFullContextPath() {
        if (this.fullContextPath != null) {
            return this.fullContextPath;
        }
        this.fullContextPath = this.getFullContextPath0();
        return this.fullContextPath;
    }

    private String getFullContextPath0() {
        List<String> endpoints = this.httpServiceRuntime.getHttpServiceEndpoints();
        if (endpoints.isEmpty()) {
            return this.proxyContext.getServletPath().concat(this.contextPath);
        }
        String defaultEndpoint = endpoints.get(0);
        if (defaultEndpoint.length() > 0) {
            int protocol = defaultEndpoint.indexOf("://");
            if (protocol > -1) {
                defaultEndpoint = defaultEndpoint.substring(protocol + 3);
            }
            int slash = defaultEndpoint.indexOf("/");
            if (defaultEndpoint.endsWith("/")) {
                defaultEndpoint = defaultEndpoint.substring(slash, defaultEndpoint.length() - 1);
            }
        }
        return defaultEndpoint + this.contextPath;
    }

    public HttpServiceRuntimeImpl getHttpServiceRuntime() {
        return this.httpServiceRuntime;
    }

    public Map<String, String> getInitParams() {
        return this.initParams;
    }

    public Set<ListenerRegistration> getListenerRegistrations() {
        return this.listenerRegistrations;
    }

    public ProxyContext getProxyContext() {
        return this.proxyContext;
    }

    public long getServiceId() {
        return this.contextServiceId;
    }

    public synchronized ServletContextDTO getServletContextDTO() {
        ServletContextDTO servletContextDTO = new ServletContextDTO();
        ServletContext servletContext = this.proxyContext.getServletContext();
        servletContextDTO.attributes = this.getDTOAttributes(servletContext);
        servletContextDTO.contextPath = this.getContextPath();
        servletContextDTO.initParams = new HashMap<String, String>(this.initParams);
        servletContextDTO.name = this.getContextName();
        servletContextDTO.serviceId = this.getServiceId();
        this.collectEndpointDTOs(servletContextDTO);
        this.collectFilterDTOs(servletContextDTO);
        this.collectListenerDTOs(servletContextDTO);
        return servletContextDTO;
    }

    public boolean matches(ServiceReference<?> whiteBoardService) {
        if (!this.visibleContextHelper(whiteBoardService)) {
            return false;
        }
        String contextSelector = (String)whiteBoardService.getProperty("osgi.http.whiteboard.context.select");
        if (this.contextName.equals(contextSelector)) {
            return true;
        }
        if (contextSelector == null && (contextSelector = this.httpServiceRuntime.getDefaultContextSelectFilter(whiteBoardService)) == null) {
            contextSelector = "(osgi.http.whiteboard.context.name=default)";
        }
        if (contextSelector.startsWith("(")) {
            Filter targetFilter;
            try {
                targetFilter = FrameworkUtil.createFilter((String)contextSelector);
            }
            catch (InvalidSyntaxException ise) {
                throw new IllegalArgumentException(ise);
            }
            if (this.matches(targetFilter)) {
                return true;
            }
        }
        return false;
    }

    private boolean visibleContextHelper(ServiceReference<?> whiteBoardService) {
        Boolean defaultContextHelper;
        if (this.consumingContext.getBundle().equals(this.serviceReference.getBundle()) && (defaultContextHelper = (Boolean)this.serviceReference.getProperty("equinox.http.whiteboard.context.helper.default")) == null) {
            return true;
        }
        try {
            if (whiteBoardService.getBundle().getBundleContext().getAllServiceReferences(ServletContextHelper.class.getName(), this.servletContextHelperRefFilter) != null) {
                return true;
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        return false;
    }

    public boolean matches(Filter targetFilter) {
        return targetFilter.match(this.serviceReference);
    }

    public String toString() {
        Object value = this.string;
        if (value == null) {
            this.string = value = SIMPLE_NAME + "[" + this.contextName + ", " + String.valueOf(this.trackingContext.getBundle()) + "]";
        }
        return value;
    }

    private void addEnpointRegistrationsToRequestInfo(EndpointRegistration<?> endpointRegistration, RequestInfoDTO requestInfoDTO) {
        if (requestInfoDTO == null) {
            return;
        }
        requestInfoDTO.servletContextId = this.getServiceId();
        if (endpointRegistration instanceof ResourceRegistration) {
            requestInfoDTO.resourceDTO = (ResourceDTO)((Object)endpointRegistration.getD());
        } else {
            requestInfoDTO.servletDTO = (ServletDTO)((Object)endpointRegistration.getD());
        }
    }

    private void addFilterRegistrationsToRequestInfo(List<FilterRegistration> matchedFilterRegistrations, RequestInfoDTO requestInfoDTO) {
        if (requestInfoDTO == null) {
            return;
        }
        ArrayList<FilterDTO> filterDTOs = new ArrayList<FilterDTO>();
        for (FilterRegistration filterRegistration : matchedFilterRegistrations) {
            if (Arrays.binarySearch(((FilterDTO)((Object)filterRegistration.getD())).dispatcher, DispatcherType.REQUEST.toString()) <= -1) continue;
            filterDTOs.add((FilterDTO)((Object)filterRegistration.getD()));
        }
        requestInfoDTO.filterDTOs = filterDTOs.toArray(new FilterDTO[0]);
    }

    private String[] asStringArray(List<Class<? extends EventListener>> clazzes) {
        Object[] classesArray = new String[clazzes.size()];
        int i = 0;
        while (i < classesArray.length) {
            classesArray[i] = clazzes.get(i).getName();
            ++i;
        }
        Arrays.sort(classesArray);
        return classesArray;
    }

    private String[] checkDispatcher(String[] dispatcher) {
        if (dispatcher == null || dispatcher.length == 0) {
            return DISPATCHER;
        }
        String[] stringArray = dispatcher;
        int n = dispatcher.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            try {
                DispatcherType.valueOf((String)type);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new HttpWhiteboardFailureException("Invalid dispatcher '" + type + "'", 6);
            }
            ++n2;
        }
        Arrays.sort(dispatcher);
        return dispatcher;
    }

    public static void checkPattern(String pattern) {
        if (pattern == null) {
            throw new HttpWhiteboardFailureException("Pattern cannot be null", 6);
        }
        if (pattern.indexOf("*.") == 0) {
            return;
        }
        if ("".equals(pattern)) {
            return;
        }
        if ("/".equals(pattern)) {
            return;
        }
        if (!pattern.startsWith("/") || pattern.endsWith("/") && !pattern.equals("/") || pattern.contains("**")) {
            throw new HttpWhiteboardFailureException("Invalid pattern '" + pattern + "'", 6);
        }
    }

    private static void checkPrefix(Object prefixObj) {
        if (prefixObj == null) {
            throw new HttpWhiteboardFailureException("Prefix cannot be null.", 6);
        }
        if (!(prefixObj instanceof String)) {
            throw new HttpWhiteboardFailureException("Prefix must be String.", 6);
        }
        String prefix = (String)prefixObj;
        if (prefix.endsWith("/") && !prefix.equals("/")) {
            throw new HttpWhiteboardFailureException("Invalid prefix '" + prefix + "'", 6);
        }
    }

    private static void checkRegex(String regex) {
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new HttpWhiteboardFailureException("Invalid regex '" + regex + "'", 6);
        }
    }

    public synchronized void checkShutdown() {
        if (this.shutdown) {
            throw new IllegalStateException("Context is already shutdown");
        }
    }

    private static String createFilter(long contextServiceId) {
        StringBuilder filterBuilder = new StringBuilder();
        filterBuilder.append('(');
        filterBuilder.append("service.id");
        filterBuilder.append('=');
        filterBuilder.append(contextServiceId);
        filterBuilder.append(')');
        return filterBuilder.toString();
    }

    private ServletContext createServletContext(Bundle curBundle, ServletContextHelper curServletContextHelper) {
        ServletContextAdaptor adaptor = new ServletContextAdaptor(this, curBundle, curServletContextHelper, this.eventListeners, AccessController.getContext());
        return adaptor.createServletContext();
    }

    private void collectEndpointDTOs(ServletContextDTO servletContextDTO) {
        ArrayList<ErrorPageDTO> errorPageDTOs = new ArrayList<ErrorPageDTO>();
        ArrayList<ResourceDTO> resourceDTOs = new ArrayList<ResourceDTO>();
        ArrayList<ServletDTO> servletDTOs = new ArrayList<ServletDTO>();
        for (EndpointRegistration<?> endpointRegistration : this.endpointRegistrations) {
            if (endpointRegistration instanceof ResourceRegistration) {
                if (this.httpServiceRuntime.isFailedResourceDTO(endpointRegistration.getServiceReference())) continue;
                resourceDTOs.add(DTOUtil.clone((ResourceDTO)((Object)endpointRegistration.getD())));
                continue;
            }
            if (endpointRegistration instanceof ErrorPageRegistration) {
                if (this.httpServiceRuntime.isFailedErrorPageDTO(endpointRegistration.getServiceReference())) continue;
                errorPageDTOs.add(DTOUtil.clone((ExtendedErrorPageDTO)((Object)endpointRegistration.getD())));
                continue;
            }
            if (this.httpServiceRuntime.isFailedServletDTO(endpointRegistration.getServiceReference())) continue;
            servletDTOs.add(DTOUtil.clone((ServletDTO)((Object)endpointRegistration.getD())));
        }
        servletContextDTO.errorPageDTOs = errorPageDTOs.toArray(new ErrorPageDTO[0]);
        servletContextDTO.resourceDTOs = resourceDTOs.toArray(new ResourceDTO[0]);
        servletContextDTO.servletDTOs = servletDTOs.toArray(new ServletDTO[0]);
    }

    private void collectFilterDTOs(ServletContextDTO servletContextDTO) {
        ArrayList<FilterDTO> filterDTOs = new ArrayList<FilterDTO>();
        for (FilterRegistration filterRegistration : this.filterRegistrations) {
            filterDTOs.add(DTOUtil.clone((FilterDTO)((Object)filterRegistration.getD())));
        }
        servletContextDTO.filterDTOs = filterDTOs.toArray(new FilterDTO[0]);
    }

    private void collectListenerDTOs(ServletContextDTO servletContextDTO) {
        ArrayList<ListenerDTO> listenerDTOs = new ArrayList<ListenerDTO>();
        for (ListenerRegistration listenerRegistration : this.listenerRegistrations) {
            listenerDTOs.add(DTOUtil.clone((ListenerDTO)((Object)listenerRegistration.getD())));
        }
        servletContextDTO.listenerDTOs = listenerDTOs.toArray(new ListenerDTO[0]);
    }

    private Map<String, Object> getDTOAttributes(ServletContext servletContext) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration names = servletContext.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            map.put(name, DTOUtil.mapValue(servletContext.getAttribute(name)));
        }
        return Collections.unmodifiableMap(map);
    }

    private List<Class<? extends EventListener>> getListenerClasses(ServiceReference<EventListener> listenerReference) {
        List<String> objectClassList = StringPlus.from(listenerReference.getProperty("objectClass"));
        ArrayList<Class<? extends EventListener>> classes = new ArrayList<Class<? extends EventListener>>();
        if (objectClassList.contains(ServletContextListener.class.getName())) {
            classes.add(ServletContextListener.class);
        }
        if (objectClassList.contains(ServletContextAttributeListener.class.getName())) {
            classes.add(ServletContextAttributeListener.class);
        }
        if (objectClassList.contains(ServletRequestListener.class.getName())) {
            classes.add(ServletRequestListener.class);
        }
        if (objectClassList.contains(ServletRequestAttributeListener.class.getName())) {
            classes.add(ServletRequestAttributeListener.class);
        }
        if (objectClassList.contains(HttpSessionListener.class.getName())) {
            classes.add(HttpSessionListener.class);
        }
        if (objectClassList.contains(HttpSessionAttributeListener.class.getName())) {
            classes.add(HttpSessionAttributeListener.class);
        }
        if (objectClassList.contains(HttpSessionIdListener.class.getName())) {
            classes.add(HttpSessionIdListener.class);
        }
        return classes;
    }

    public ServiceReference<ServletContextHelper> getServiceReference() {
        return this.serviceReference;
    }

    private ServletContextHelper getServletContextHelper(Bundle curBundle) {
        BundleContext context = curBundle.getBundleContext();
        return (ServletContextHelper)context.getService(this.serviceReference);
    }

    public void ungetServletContextHelper(Bundle curBundle) {
        BundleContext context = curBundle.getBundleContext();
        try {
            context.ungetService(this.serviceReference);
        }
        catch (IllegalStateException illegalStateException) {}
    }

    private String[] sort(String[] values) {
        if (values == null) {
            return null;
        }
        Arrays.sort(values);
        return values;
    }

    private void flushActiveSessions() {
        Collection httpSessionAdaptors = this.activeSessions.values();
        Iterator iterator = httpSessionAdaptors.iterator();
        while (iterator.hasNext()) {
            HttpSessionAdaptor httpSessionAdaptor = (HttpSessionAdaptor)iterator.next();
            httpSessionAdaptor.invalidate();
            iterator.remove();
        }
    }

    public void removeActiveSession(HttpSession session) {
        this.removeActiveSession(session.getId());
    }

    public void removeActiveSession(String sessionId) {
        HttpSessionAdaptor httpSessionAdaptor = (HttpSessionAdaptor)this.activeSessions.remove(sessionId);
        if (httpSessionAdaptor != null) {
            this.httpServiceRuntime.getHttpSessionTracker().removeHttpSessionAdaptor(sessionId, httpSessionAdaptor);
        }
    }

    public void fireSessionIdChanged(String oldSessionId) {
        if (this.shutdown) {
            return;
        }
        List<HttpSessionIdListener> listeners = this.eventListeners.get(HttpSessionIdListener.class);
        if (listeners.isEmpty()) {
            return;
        }
        for (HttpSessionAdaptor httpSessionAdaptor : this.activeSessions.values()) {
            HttpSessionEvent httpSessionEvent = new HttpSessionEvent((HttpSession)httpSessionAdaptor);
            for (HttpSessionIdListener listener : listeners) {
                listener.sessionIdChanged(httpSessionEvent, oldSessionId);
            }
        }
    }

    public HttpSessionAdaptor getSessionAdaptor(HttpSession session, ServletContext servletContext) {
        String sessionId = session.getId();
        HttpSessionAdaptor httpSessionAdaptor = (HttpSessionAdaptor)this.activeSessions.get(sessionId);
        if (httpSessionAdaptor != null) {
            return httpSessionAdaptor;
        }
        httpSessionAdaptor = HttpSessionAdaptor.createHttpSessionAdaptor(session, servletContext, this);
        HttpSessionAdaptor previousHttpSessionAdaptor = this.addSessionAdaptor(sessionId, httpSessionAdaptor);
        if (previousHttpSessionAdaptor != null) {
            return previousHttpSessionAdaptor;
        }
        List<HttpSessionListener> listeners = this.eventListeners.get(HttpSessionListener.class);
        if (listeners.isEmpty()) {
            return httpSessionAdaptor;
        }
        HttpSessionEvent httpSessionEvent = new HttpSessionEvent((HttpSession)httpSessionAdaptor);
        for (HttpSessionListener listener : listeners) {
            listener.sessionCreated(httpSessionEvent);
        }
        return httpSessionAdaptor;
    }

    public HttpSessionAdaptor addSessionAdaptor(String sessionId, HttpSessionAdaptor httpSessionAdaptor) {
        HttpSessionAdaptor previousHttpSessionAdaptor = this.activeSessions.putIfAbsent(sessionId, httpSessionAdaptor);
        if (previousHttpSessionAdaptor != null) {
            return previousHttpSessionAdaptor;
        }
        this.httpServiceRuntime.getHttpSessionTracker().addHttpSessionAdaptor(sessionId, httpSessionAdaptor);
        return null;
    }

    public void recordFailedErrorPageDTO(ServiceReference<?> servletReference, ExtendedErrorPageDTO errorPageDTO, int failureReason) {
        FailedErrorPageDTO failedErrorPageDTO = new FailedErrorPageDTO();
        failedErrorPageDTO.asyncSupported = errorPageDTO.asyncSupported;
        failedErrorPageDTO.errorCodes = errorPageDTO.errorCodes;
        failedErrorPageDTO.exceptions = errorPageDTO.exceptions;
        failedErrorPageDTO.failureReason = failureReason;
        failedErrorPageDTO.initParams = errorPageDTO.initParams;
        failedErrorPageDTO.name = errorPageDTO.name;
        failedErrorPageDTO.serviceId = errorPageDTO.serviceId;
        failedErrorPageDTO.servletContextId = errorPageDTO.servletContextId;
        failedErrorPageDTO.servletInfo = errorPageDTO.servletInfo;
        this.getHttpServiceRuntime().recordFailedErrorPageDTO(servletReference, failedErrorPageDTO);
    }

    public void recordFailedResourceDTO(ServiceReference<?> resourceReference, ResourceDTO resourceDTO, int failureReason) {
        FailedResourceDTO failedResourceDTO = new FailedResourceDTO();
        failedResourceDTO.failureReason = failureReason;
        failedResourceDTO.patterns = resourceDTO.patterns;
        failedResourceDTO.prefix = resourceDTO.prefix;
        failedResourceDTO.serviceId = resourceDTO.serviceId;
        failedResourceDTO.servletContextId = resourceDTO.servletContextId;
        this.getHttpServiceRuntime().recordFailedResourceDTO(resourceReference, failedResourceDTO);
    }

    public void recordFailedServletDTO(ServiceReference<?> servletReference, ServletDTO servletDTO, int failureReason) {
        FailedServletDTO failedServletDTO = new FailedServletDTO();
        failedServletDTO.asyncSupported = servletDTO.asyncSupported;
        failedServletDTO.failureReason = failureReason;
        failedServletDTO.initParams = servletDTO.initParams;
        failedServletDTO.multipartEnabled = servletDTO.multipartEnabled;
        failedServletDTO.multipartFileSizeThreshold = servletDTO.multipartFileSizeThreshold;
        failedServletDTO.multipartLocation = servletDTO.multipartLocation;
        failedServletDTO.multipartMaxFileSize = servletDTO.multipartMaxFileSize;
        failedServletDTO.multipartMaxRequestSize = servletDTO.multipartMaxRequestSize;
        failedServletDTO.name = servletDTO.name;
        failedServletDTO.patterns = servletDTO.patterns;
        failedServletDTO.serviceId = servletDTO.serviceId;
        failedServletDTO.servletContextId = servletDTO.servletContextId;
        failedServletDTO.servletInfo = servletDTO.servletInfo;
        this.getHttpServiceRuntime().recordFailedServletDTO(servletReference, failedServletDTO);
    }

    private String validateName() {
        Object contextNameObj = this.serviceReference.getProperty("osgi.http.whiteboard.context.name");
        if (contextNameObj == null) {
            throw new IllegalContextNameException("osgi.http.whiteboard.context.name is null. Ignoring!", 6);
        }
        if (!(contextNameObj instanceof String)) {
            throw new IllegalContextNameException("osgi.http.whiteboard.context.name is not String. Ignoring!", 6);
        }
        String name = (String)contextNameObj;
        if (!contextNamePattern.matcher(name).matches()) {
            throw new IllegalContextNameException("The context name '" + name + "' does not follow Bundle-SymbolicName syntax.", 6);
        }
        for (ContextController existingContext : this.httpServiceRuntime.getContextControllers()) {
            if (!name.equals(existingContext.getContextName())) continue;
            if (this.serviceReference.compareTo(existingContext.serviceReference) < 0) {
                throw new HttpWhiteboardFailureException("Context with same name exists. " + String.valueOf(this.serviceReference), 6);
            }
            this.httpServiceRuntime.recordFailedServletContextDTO(existingContext.serviceReference, (Long)this.serviceReference.getProperty("service.id"), 3);
        }
        return name;
    }

    private String validatePath() {
        Object contextPathObj = this.serviceReference.getProperty("osgi.http.whiteboard.context.path");
        if (contextPathObj == null) {
            throw new IllegalContextPathException("osgi.http.whiteboard.context.path is null. Ignoring!", 6);
        }
        if (!(contextPathObj instanceof String)) {
            throw new IllegalContextPathException("osgi.http.whiteboard.context.path is not String. Ignoring!", 6);
        }
        String path = (String)contextPathObj;
        try {
            new URI("http", "localhost", path, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalContextPathException("The context path '" + path + "' is not valid URI path syntax.", 6);
        }
        path = this.httpServiceRuntime.adaptContextPath(path, this.serviceReference);
        if (path.equals("/")) {
            path = "";
        }
        return path;
    }
}

