/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources.nested;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.internal.navigator.resources.nested.PathComparator;

public class NestedProjectManager {
    private static NestedProjectManager INSTANCE = new NestedProjectManager();
    private SortedMap<IPath, IProject> locationsToProjects = new TreeMap<IPath, IProject>(new PathComparator());

    private NestedProjectManager() {
        this.refreshProjectsList();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(event -> {
            IResourceDelta delta = event.getDelta();
            IResource resource = null;
            if (delta != null) {
                resource = delta.getResource();
            }
            if (resource != null && (resource.getType() == 4 || resource.getType() == 8)) {
                this.refreshProjectsList();
            }
        }, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshProjectsList() {
        IProject[] knownProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        SortedMap<IPath, IProject> sortedMap = this.locationsToProjects;
        synchronized (sortedMap) {
            this.locationsToProjects.clear();
            IProject[] iProjectArray = knownProjects;
            int n = knownProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                IPath location = project.getLocation();
                if (location != null) {
                    this.locationsToProjects.put(location, project);
                }
                ++n2;
            }
        }
    }

    public static NestedProjectManager getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProject getProject(IFolder folder) {
        IProject res;
        if (folder == null) {
            return null;
        }
        IPath location = folder.getLocation();
        if (location == null) {
            return null;
        }
        SortedMap<IPath, IProject> sortedMap = this.locationsToProjects;
        synchronized (sortedMap) {
            res = (IProject)this.locationsToProjects.get(location);
        }
        if (!(res == null || res.exists() && location.equals((Object)res.getLocation()))) {
            this.refreshProjectsList();
            return this.getProject(folder);
        }
        return res;
    }

    public boolean isShownAsProject(IFolder folder) {
        return this.getProject(folder) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isShownAsNested(IProject project) {
        if (!project.exists()) {
            return false;
        }
        IPath location = project.getLocation();
        if (location == null) {
            return false;
        }
        IPath queriedLocation = location.removeLastSegments(1);
        SortedMap<IPath, IProject> sortedMap = this.locationsToProjects;
        synchronized (sortedMap) {
            while (true) {
                if (queriedLocation.segmentCount() <= 0) {
                    return false;
                }
                if (this.locationsToProjects.containsKey(queriedLocation)) {
                    return true;
                }
                queriedLocation = queriedLocation.removeLastSegments(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IContainer getMostDirectOpenContainer(IProject project) {
        IPath location = project.getLocation();
        if (location == null) {
            return null;
        }
        IProject mostDirectParentProject = null;
        IPath queriedLocation = location.removeLastSegments(1);
        SortedMap<IPath, IProject> sortedMap = this.locationsToProjects;
        synchronized (sortedMap) {
            while (mostDirectParentProject == null && queriedLocation.segmentCount() > 0) {
                mostDirectParentProject = (IProject)this.locationsToProjects.get(queriedLocation);
                if (mostDirectParentProject != null && mostDirectParentProject.getLocation() == null) {
                    mostDirectParentProject = null;
                }
                queriedLocation = queriedLocation.removeLastSegments(1);
            }
        }
        if (mostDirectParentProject != null) {
            IPath parentContainerAbsolutePath = location.removeLastSegments(1);
            IPath location2 = mostDirectParentProject.getLocation();
            if (location2 == null) {
                return null;
            }
            if (parentContainerAbsolutePath.equals((Object)location2)) {
                return mostDirectParentProject;
            }
            IPath parentFolderPathRelativeToProject = parentContainerAbsolutePath.removeFirstSegments(location2.segmentCount());
            return mostDirectParentProject.getFolder(parentFolderPathRelativeToProject);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProject[] getDirectChildrenProjects(IContainer container) {
        if (container instanceof IWorkspaceRoot) {
            IWorkspaceRoot root = (IWorkspaceRoot)container;
            return root.getProjects();
        }
        HashSet<IProject> res = new HashSet<IProject>();
        IPath containerLocation = container.getLocation();
        IPath projectLocation = container.getProject().getLocation();
        if (containerLocation == null || projectLocation == null) {
            return res.toArray(new IProject[res.size()]);
        }
        SortedMap<IPath, IProject> sortedMap = this.locationsToProjects;
        synchronized (sortedMap) {
            for (Map.Entry<IPath, IProject> entry : this.locationsToProjects.tailMap(containerLocation).entrySet()) {
                if (entry.getValue().equals((Object)container.getProject())) continue;
                if (!containerLocation.isPrefixOf(entry.getKey())) break;
                if (entry.getKey().segmentCount() != containerLocation.segmentCount() + 1) continue;
                res.add(entry.getValue());
            }
        }
        return res.toArray(new IProject[res.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasDirectChildrenProjects(IContainer container) {
        if (container instanceof IWorkspaceRoot) {
            IWorkspaceRoot root = (IWorkspaceRoot)container;
            if (root.getProjects().length <= 0) return false;
            return true;
        }
        IPath containerLocation = container.getLocation();
        IPath projectLocation = container.getProject().getLocation();
        if (containerLocation == null) return false;
        if (projectLocation == null) {
            return false;
        }
        SortedMap<IPath, IProject> sortedMap = this.locationsToProjects;
        synchronized (sortedMap) {
            Iterator<Map.Entry<IPath, IProject>> iterator = this.locationsToProjects.tailMap(containerLocation).entrySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return false;
                }
                Map.Entry<IPath, IProject> entry = iterator.next();
                if (entry.getValue().equals((Object)container.getProject())) continue;
                if (!containerLocation.isPrefixOf(entry.getKey())) return false;
                if (entry.getKey().segmentCount() == containerLocation.segmentCount() + 1) break;
            }
            return true;
        }
    }
}

