/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.completion.provider;

import java.util.Collection;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ease.ICompletionContext;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.service.ScriptService;
import org.eclipse.ease.ui.Activator;
import org.eclipse.ease.ui.completion.IImageResolver;
import org.eclipse.ease.ui.completion.provider.AbstractCompletionProvider;
import org.eclipse.ease.ui.completion.provider.AbstractPathCompletionProvider;
import org.eclipse.jface.viewers.StyledString;

public class LoadModuleCompletionProvider
extends AbstractPathCompletionProvider {
    @Override
    public boolean isActive(ICompletionContext context) {
        return super.isActive(context) && this.isMethodParameter(context, "loadModule", 0) && this.isStringParameter(context);
    }

    @Override
    protected void prepareProposals(ICompletionContext context) {
        ScriptService scriptService = ScriptService.getInstance();
        Collection availableModules = scriptService.getAvailableModules();
        Collection<IPath> paths = this.filter(this.getPathsFromElements(availableModules), context);
        paths.stream().forEach(p -> this.addProposal(p.toString(), String.valueOf(p.toString()) + "/", (IImageResolver)new AbstractCompletionProvider.WorkbenchDescriptorImageResolver("IMG_OBJ_FOLDER"), 100, null));
        Collection modules = this.filter(availableModules, context);
        modules.stream().forEach(m -> {
            StyledString displayString = new StyledString(m.getPath().lastSegment());
            if (!m.isVisible()) {
                displayString.append(" (hidden)", StyledString.DECORATIONS_STYLER);
            }
            this.addProposal(displayString, m.getPath().toString(), (IImageResolver)new AbstractCompletionProvider.DescriptorImageResolver(Activator.getImageDescriptor("org.eclipse.ease.ui", "/icons/eobj16/module.png")), 90, null);
        });
    }

    @Override
    protected IPath toPath(Object element) {
        if (element instanceof ModuleDefinition) {
            return ((ModuleDefinition)element).getPath();
        }
        throw new IllegalArgumentException("element is not of type ModuleDefinition");
    }
}

