/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.quicksearch.internal.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.quicksearch.internal.ui.QuickSearchActivator;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class DocumentFetcher {
    private Map<IFile, IDocument> dirtyEditors;
    private IFile lastFile = null;
    private IDocument lastDocument = null;
    IDocumentProvider provider = new TextFileDocumentProvider();

    public DocumentFetcher() {
        this.dirtyEditors = PlatformUI.isWorkbenchRunning() ? this.evalNonFileBufferDocuments() : Collections.emptyMap();
    }

    public IDocument getDocument(IFile file) {
        if (file == this.lastFile) {
            return this.lastDocument;
        }
        this.lastFile = file;
        this.lastDocument = this.dirtyEditors.get(file);
        if (this.lastDocument == null) {
            this.lastDocument = this.getOpenDocument(file);
            if (this.lastDocument == null) {
                this.lastDocument = this.getClosedDocument(file);
            }
        }
        return this.lastDocument;
    }

    private IDocument getOpenDocument(IFile file) {
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
        if (textFileBuffer != null) {
            return textFileBuffer.getDocument();
        }
        return null;
    }

    private IDocument getClosedDocument(IFile file) {
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        IPath location = file.getFullPath();
        ITextFileBuffer buffer = null;
        try {
            bufferManager.connect(location, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
            buffer = bufferManager.getTextFileBuffer(location, LocationKind.IFILE);
            if (buffer != null) {
                IDocument iDocument = buffer.getDocument();
                return iDocument;
            }
        }
        catch (Throwable e) {
            QuickSearchActivator.log(e);
        }
        finally {
            try {
                bufferManager.disconnect(location, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    private Map<IFile, IDocument> evalNonFileBufferDocuments() {
        HashMap<IFile, IDocument> result = new HashMap<IFile, IDocument>();
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference editorRef = iEditorReferenceArray[n6];
                    IEditorPart ep = editorRef.getEditor(false);
                    if (ep instanceof ITextEditor && ep.isDirty()) {
                        this.evaluateTextEditor(result, ep);
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    private void evaluateTextEditor(Map<IFile, IDocument> result, IEditorPart ep) {
        IFile file;
        IEditorInput input = ep.getEditorInput();
        if (input instanceof IFileEditorInput && !result.containsKey(file = ((IFileEditorInput)input).getFile())) {
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
            if (textFileBuffer != null) {
                result.put(file, textFileBuffer.getDocument());
            } else {
                IDocument document = ((ITextEditor)ep).getDocumentProvider().getDocument((Object)input);
                if (document != null) {
                    result.put(file, document);
                }
            }
        }
    }
}

