/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.OpenBrowserUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;
import org.eclipse.wst.jsdt.ui.JavaScriptUI;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class OpenExternalJavadocAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public OpenExternalJavadocAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.OpenExternalJavadocAction_label);
        this.setDescription(ActionMessages.OpenExternalJavadocAction_description);
        this.setToolTipText(ActionMessages.OpenExternalJavadocAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.open_external_javadoc_action");
    }

    public OpenExternalJavadocAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.checkEnabled(selection));
    }

    private boolean checkEnabled(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        return selection.getFirstElement() instanceof IJavaScriptElement;
    }

    @Override
    public void run(ITextSelection selection) {
        IJavaScriptElement element = SelectionConverter.getInput(this.fEditor);
        if (!ActionUtil.isProcessable(this.getShell(), element)) {
            return;
        }
        try {
            IJavaScriptElement[] elements = SelectionConverter.codeResolveOrInputForked(this.fEditor);
            if (elements == null || elements.length == 0) {
                return;
            }
            IJavaScriptElement candidate = elements[0];
            if (elements.length > 1) {
                candidate = SelectionConverter.selectJavaElement(elements, this.getShell(), this.getDialogTitle(), ActionMessages.OpenExternalJavadocAction_select_element);
            }
            if (candidate != null) {
                this.run(candidate);
            }
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), this.getDialogTitle(), ActionMessages.OpenExternalJavadocAction_code_resolve_failed);
        }
        catch (InterruptedException interruptedException) {}
    }

    @Override
    public void run(IStructuredSelection selection) {
        if (!this.checkEnabled(selection)) {
            return;
        }
        IJavaScriptElement element = (IJavaScriptElement)selection.getFirstElement();
        if (!ActionUtil.isProcessable(this.getShell(), element)) {
            return;
        }
        this.run(element);
    }

    public void run(IJavaScriptElement element) {
        if (element == null) {
            return;
        }
        Shell shell = this.getShell();
        try {
            String labelName = JavaScriptElementLabels.getElementLabel(element, 0x20000AL);
            URL baseURL = JavaScriptUI.getJSdocBaseLocation(element);
            if (baseURL == null) {
                IPackageFragmentRoot root = JavaModelUtil.getPackageFragmentRoot(element);
                if (root != null && root.getKind() == 2) {
                    String message = ActionMessages.OpenExternalJavadocAction_libraries_no_location;
                    OpenExternalJavadocAction.showMessage(shell, Messages.format(message, new String[]{labelName, root.getElementName()}), false);
                } else {
                    IJavaScriptProject annotatedElement = element.getJavaScriptProject();
                    String message = ActionMessages.OpenExternalJavadocAction_source_no_location;
                    OpenExternalJavadocAction.showMessage(shell, Messages.format(message, new String[]{labelName, annotatedElement.getElementName()}), false);
                }
                return;
            }
            URL url = JavaScriptUI.getJSdocLocation(element, true);
            if (url != null) {
                OpenBrowserUtil.open(url, shell.getDisplay(), OpenExternalJavadocAction.getTitle());
            }
        }
        catch (CoreException e) {
            JavaScriptPlugin.log(e);
            OpenExternalJavadocAction.showMessage(shell, ActionMessages.OpenExternalJavadocAction_opening_failed, true);
        }
    }

    private static void showMessage(final Shell shell, final String message, final boolean isError) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (isError) {
                    MessageDialog.openError((Shell)shell, (String)OpenExternalJavadocAction.getTitle(), (String)message);
                } else {
                    MessageDialog.openInformation((Shell)shell, (String)OpenExternalJavadocAction.getTitle(), (String)message);
                }
            }
        });
    }

    private static String getTitle() {
        return ActionMessages.OpenExternalJavadocAction_dialog_title;
    }

    protected String getDialogTitle() {
        return OpenExternalJavadocAction.getTitle();
    }
}

