/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.otf2.core.analysis;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.otf2.core.Activator;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.IOtf2Constants;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.callstack.Otf2CallStackStateProvider;
import org.eclipse.tracecompass.incubator.internal.otf2.core.trace.AttributeDefinition;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public abstract class AbstractOtf2StateProvider
extends AbstractTmfStateProvider {
    protected static final long UNKNOWN_LOCATION_ID = -1L;
    protected static final int UNKNOWN_RANK = -1;
    protected static final int UNKNOWN_ID = -1;
    protected final Map<Integer, AttributeDefinition> fAttributeDefinitions;
    private final Map<Integer, String> fStringId = new HashMap<Integer, String>();
    private final Map<Integer, Integer> fRegionStringId = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> fCommunicatorGroup = new HashMap<Integer, Integer>();
    private final Map<Integer, @Nullable ArrayList<Long>> fGroupMembers = new HashMap<Integer, ArrayList<Long>>();

    protected AbstractOtf2StateProvider(@Nullable ITmfTrace trace, String id) {
        super(Objects.requireNonNull(trace), id);
        this.fAttributeDefinitions = new HashMap<Integer, AttributeDefinition>();
    }

    public ITmfStateProvider getNewInstance() {
        try {
            return Objects.requireNonNull((ITmfStateProvider)((Object)((Object)this)).getClass().getConstructor(ITmfTrace.class).newInstance(this.getTrace()));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            Activator.getInstance().logError("Error instantiating state provider");
            return new Otf2CallStackStateProvider(this.getTrace());
        }
    }

    protected void eventHandle(ITmfEvent event) {
        ITmfEventField content = event.getContent();
        if (content == null) {
            return;
        }
        ITmfStateSystemBuilder ssb = this.getStateSystemBuilder();
        if (ssb == null) {
            return;
        }
        String ctfEventName = event.getName();
        Matcher matcher = IOtf2Constants.OTF2_EVENT_NAME_PATTERN.matcher(ctfEventName);
        if (!matcher.matches()) {
            return;
        }
        String eventType = matcher.group("type");
        String otf2EventName = matcher.group("name");
        if (otf2EventName == null) {
            return;
        }
        switch (eventType) {
            case "GlobalDef": {
                this.processGlobalDefinition(event, otf2EventName);
                break;
            }
            case "Event": {
                this.processOtf2Event(event, otf2EventName, ssb);
                break;
            }
            case "EventAttribute": {
                this.processOtf2EventAttribute(event, otf2EventName, ssb);
                break;
            }
            default: {
                return;
            }
        }
    }

    protected void processOtf2EventAttribute(ITmfEvent event, String otf2EventName, ITmfStateSystemBuilder ssb) {
    }

    protected abstract void processGlobalDefinition(ITmfEvent var1, String var2);

    protected void processStringDefinition(ITmfEvent event) {
        ITmfEventField content = event.getContent();
        Integer stringReference = (Integer)content.getFieldValue(Integer.class, new String[]{"self"});
        String stringValue = (String)content.getFieldValue(String.class, new String[]{"stringValue"});
        if (stringReference == null || stringValue == null) {
            return;
        }
        this.fStringId.put(stringReference, stringValue);
    }

    protected void processRegionDefinition(ITmfEvent event) {
        ITmfEventField content = event.getContent();
        Integer regionReference = (Integer)content.getFieldValue(Integer.class, new String[]{"self"});
        Integer stringReference = (Integer)content.getFieldValue(Integer.class, new String[]{"name"});
        if (regionReference == null || stringReference == null) {
            return;
        }
        this.fRegionStringId.put(regionReference, stringReference);
    }

    protected void processCommunicatorDefinition(ITmfEvent event) {
        ITmfEventField content = event.getContent();
        Integer communicatorReference = (Integer)content.getFieldValue(Integer.class, new String[]{"self"});
        Integer groupReference = (Integer)content.getFieldValue(Integer.class, new String[]{"group"});
        if (communicatorReference == null || groupReference == null) {
            return;
        }
        this.fCommunicatorGroup.put(communicatorReference, groupReference);
    }

    protected void processGroupDefinition(ITmfEvent event) {
        ITmfEventField content = event.getContent();
        Integer groupReference = (Integer)content.getFieldValue(Integer.class, new String[]{"self"});
        Integer numberOfMembers = (Integer)content.getFieldValue(Integer.class, new String[]{"numberOfMembers"});
        if (groupReference == null || numberOfMembers == null) {
            return;
        }
        if (numberOfMembers == 0) {
            this.fGroupMembers.put(groupReference, null);
            return;
        }
        ArrayList<Long> membersArray = new ArrayList<Long>(numberOfMembers);
        int i = 0;
        while (i < numberOfMembers) {
            membersArray.add(-1L);
            ++i;
        }
        this.fGroupMembers.put(groupReference, membersArray);
    }

    protected void processGroupMemberDefinition(ITmfEvent event) {
        ITmfEventField content = event.getContent();
        Integer groupReference = (Integer)content.getFieldValue(Integer.class, new String[]{"group"});
        Integer rank = (Integer)content.getFieldValue(Integer.class, new String[]{"rank"});
        Long locationReference = (Long)content.getFieldValue(Long.class, new String[]{"location"});
        if (groupReference == null || rank == null || locationReference == null) {
            return;
        }
        ArrayList<Long> membersArray = this.fGroupMembers.get(groupReference);
        if (membersArray == null) {
            return;
        }
        membersArray.set(rank, locationReference);
        this.fGroupMembers.put(groupReference, membersArray);
    }

    protected void processAttributeDefinition(ITmfEvent event) {
        Integer attributeId = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{"self"});
        Integer nameId = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{"name"});
        Integer descriptionId = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{"description"});
        Integer typeId = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{"type"});
        if (attributeId != null && nameId != null && descriptionId != null && typeId != null) {
            this.fAttributeDefinitions.put(attributeId, new AttributeDefinition(nameId, descriptionId, typeId));
        }
    }

    protected abstract void processOtf2Event(ITmfEvent var1, String var2, ITmfStateSystemBuilder var3);

    protected static boolean isEvent(ITmfEvent event, String eventName) {
        return event.getName().equals(eventName);
    }

    protected long getLocationId(ITmfEvent event) {
        ITmfEventField content = event.getContent();
        Long locationId = (Long)content.getFieldValue(Long.class, new String[]{"locationID"});
        return locationId != null ? locationId : -1L;
    }

    protected int getRank(Long location, Integer communicatorReference) {
        Integer groupReference = this.fCommunicatorGroup.get(communicatorReference);
        ArrayList<Long> members = this.fGroupMembers.get(groupReference);
        if (members == null) {
            return -1;
        }
        return members.indexOf(location);
    }

    protected String getStringFromStringId(int stringId) {
        String stringValue = this.fStringId.get(stringId);
        if (stringValue == null) {
            return "UNKNOWN";
        }
        return stringValue;
    }

    protected String getRegionNameFromRegionId(int regionId) {
        Integer stringId = this.fRegionStringId.get(regionId);
        if (stringId == null) {
            return "UNKNOWN";
        }
        return this.getStringFromStringId(stringId);
    }

    protected ArrayList<Long> getMembersFromCommunicatorReference(int communicatorReference) {
        Integer groupReference = this.fCommunicatorGroup.get(communicatorReference);
        ArrayList<Long> members = this.fGroupMembers.get(groupReference);
        if (members == null) {
            return new ArrayList<Long>();
        }
        return members;
    }

    protected Map<Integer, String> getStringId() {
        return this.fStringId;
    }

    protected long getLocationIdFromRank(Integer rank, Integer communicatorReference) {
        ArrayList<Long> members = this.getMembersFromCommunicatorReference(communicatorReference);
        if (rank >= members.size()) {
            return -1L;
        }
        return members.get(rank);
    }
}

