/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.interceptor.InvocationContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.classic.CallbackInfo;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.assembler.classic.InterceptorBindingInfo;
import org.apache.openejb.assembler.classic.InterceptorInfo;
import org.apache.openejb.assembler.classic.MessageDrivenBeanInfo;
import org.apache.openejb.assembler.classic.MethodInfoUtil;
import org.apache.openejb.assembler.classic.NamedMethodInfo;
import org.apache.openejb.assembler.classic.StatefulBeanInfo;
import org.apache.openejb.assembler.classic.StatelessBeanInfo;
import org.apache.openejb.core.interceptor.InterceptorData;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.SetAccessible;

public class InterceptorBindingBuilder {
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, InterceptorBindingBuilder.class.getPackage().getName());
    private final List<InterceptorBindingInfo> packageAndClassBindings;
    private final EjbJarInfo ejbJarInfo;
    private final ArrayList<InterceptorBindingInfo> bindings;
    private final Map<String, InterceptorData> interceptors = new HashMap<String, InterceptorData>();

    public InterceptorBindingBuilder(ClassLoader cl, EjbJarInfo ejbJarInfo) throws OpenEJBException {
        this.ejbJarInfo = ejbJarInfo;
        this.bindings = new ArrayList<InterceptorBindingInfo>(ejbJarInfo.interceptorBindings);
        Collections.sort(this.bindings, new IntercpetorBindingComparator());
        Collections.reverse(this.bindings);
        this.packageAndClassBindings = new ArrayList<InterceptorBindingInfo>();
        for (InterceptorBindingInfo binding : this.bindings) {
            Level level = InterceptorBindingBuilder.level(binding);
            if (level != Level.PACKAGE && level != Level.CLASS && level != Level.ANNOTATION_CLASS) continue;
            this.packageAndClassBindings.add(binding);
        }
        for (InterceptorInfo info : ejbJarInfo.interceptors) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(info.clazz, true, cl);
            }
            catch (ClassNotFoundException e) {
                throw new OpenEJBException("Interceptor class cannot be loaded: " + info.clazz);
            }
            InterceptorData interceptor = new InterceptorData(clazz);
            this.toMethods(clazz, info.aroundInvoke, interceptor.getAroundInvoke());
            this.toMethods(clazz, info.postActivate, interceptor.getPostActivate());
            this.toMethods(clazz, info.prePassivate, interceptor.getPrePassivate());
            this.toMethods(clazz, info.postConstruct, interceptor.getPostConstruct());
            this.toMethods(clazz, info.preDestroy, interceptor.getPreDestroy());
            this.toMethods(clazz, info.afterBegin, interceptor.getAfterBegin());
            this.toMethods(clazz, info.beforeCompletion, interceptor.getBeforeCompletion());
            this.toMethods(clazz, info.afterCompletion, interceptor.getAfterCompletion());
            this.toMethods(clazz, info.aroundTimeout, interceptor.getAroundTimeout());
            this.interceptors.put(info.clazz, interceptor);
        }
    }

    public void build(BeanContext beanContext, EnterpriseBeanInfo beanInfo) {
        Class clazz = beanContext.getBeanClass();
        InterceptorData beanAsInterceptor = new InterceptorData(clazz);
        if (beanInfo instanceof StatelessBeanInfo || beanInfo instanceof MessageDrivenBeanInfo) {
            NamedMethodInfo info = new NamedMethodInfo();
            info.className = clazz.getName();
            info.methodName = "ejbCreate";
            info.methodParams = new ArrayList<String>();
            try {
                Method ejbcreate = MethodInfoUtil.toMethod(clazz, info);
                if (ejbcreate != null) {
                    CallbackInfo ejbcreateAsPostConstruct = new CallbackInfo();
                    ejbcreateAsPostConstruct.className = ejbcreate.getDeclaringClass().getName();
                    ejbcreateAsPostConstruct.method = "ejbCreate";
                    beanInfo.postConstruct.add(ejbcreateAsPostConstruct);
                }
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        this.toMethods(clazz, beanInfo.aroundInvoke, beanAsInterceptor.getAroundInvoke());
        this.toCallback(clazz, beanInfo.postConstruct, beanAsInterceptor.getPostConstruct(), new Class[0]);
        this.toCallback(clazz, beanInfo.preDestroy, beanAsInterceptor.getPreDestroy(), new Class[0]);
        if (beanInfo instanceof StatefulBeanInfo) {
            StatefulBeanInfo stateful = (StatefulBeanInfo)beanInfo;
            this.toCallback(clazz, stateful.postActivate, beanAsInterceptor.getPostActivate(), new Class[0]);
            this.toCallback(clazz, stateful.prePassivate, beanAsInterceptor.getPrePassivate(), new Class[0]);
            this.toCallback(clazz, stateful.afterBegin, beanAsInterceptor.getAfterBegin(), new Class[0]);
            this.toCallback(clazz, stateful.beforeCompletion, beanAsInterceptor.getBeforeCompletion(), new Class[0]);
            this.toCallback(clazz, stateful.afterCompletion, beanAsInterceptor.getAfterCompletion(), Boolean.TYPE);
        } else {
            this.toMethods(clazz, beanInfo.aroundTimeout, beanAsInterceptor.getAroundTimeout());
        }
        while (clazz != null && clazz != Object.class) {
            for (Method method : clazz.getDeclaredMethods()) {
                List<InterceptorData> methodInterceptors = this.createInterceptorDatas(method, beanInfo.ejbName, this.bindings);
                methodInterceptors.add(beanAsInterceptor);
                beanContext.setMethodInterceptors(method, methodInterceptors);
            }
            clazz = clazz.getSuperclass();
        }
        List<InterceptorData> callbackInterceptorDatas = this.createInterceptorDatas(null, beanInfo.ejbName, this.packageAndClassBindings);
        callbackInterceptorDatas.add(beanAsInterceptor);
        beanContext.setCallbackInterceptors(callbackInterceptorDatas);
    }

    private List<InterceptorData> createInterceptorDatas(Method method, String ejbName, List<InterceptorBindingInfo> bindings) {
        List<InterceptorBindingInfo> methodBindings = this.processBindings(method, ejbName, bindings);
        Collections.reverse(methodBindings);
        ArrayList<InterceptorData> methodInterceptors = new ArrayList<InterceptorData>();
        for (InterceptorBindingInfo info : methodBindings) {
            List<String> classes = info.interceptorOrder.size() > 0 ? info.interceptorOrder : info.interceptors;
            for (String interceptorClassName : classes) {
                InterceptorData interceptorData = this.interceptors.get(interceptorClassName);
                if (interceptorData == null) {
                    logger.warning("InterceptorBinding references non-existent (undeclared) interceptor: " + interceptorClassName);
                    continue;
                }
                methodInterceptors.add(interceptorData);
            }
        }
        return methodInterceptors;
    }

    private List<InterceptorBindingInfo> processBindings(Method method, String ejbName, List<InterceptorBindingInfo> bindings) {
        ArrayList<InterceptorBindingInfo> methodBindings = new ArrayList<InterceptorBindingInfo>();
        HashSet<Level> excludes = new HashSet<Level>();
        for (InterceptorBindingInfo info : bindings) {
            Level level = InterceptorBindingBuilder.level(info);
            if (!this.implies(method, ejbName, level, info)) continue;
            Type type = InterceptorBindingBuilder.type(level, info);
            if (type == Type.EXPLICIT_ORDERING && !excludes.contains((Object)level)) {
                methodBindings.add(info);
                return methodBindings;
            }
            if (type == Type.SAME_AND_LOWER_EXCLUSION) {
                return methodBindings;
            }
            if (type == Type.SAME_LEVEL_EXCLUSION) {
                excludes.add(level);
            }
            if (!excludes.contains((Object)level)) {
                methodBindings.add(info);
            }
            if (info.excludeClassInterceptors) {
                excludes.add(Level.CLASS);
                excludes.add(Level.ANNOTATION_CLASS);
            }
            if (!info.excludeDefaultInterceptors) continue;
            excludes.add(Level.PACKAGE);
        }
        return methodBindings;
    }

    private boolean implies(Method method, String ejbName, Level level, InterceptorBindingInfo info) {
        if (level == Level.PACKAGE) {
            return true;
        }
        if (!ejbName.equals(info.ejbName)) {
            return false;
        }
        if (level == Level.CLASS || level == Level.ANNOTATION_CLASS) {
            return true;
        }
        NamedMethodInfo methodInfo = info.method;
        return MethodInfoUtil.matches(method, methodInfo);
    }

    private void toMethods(Class<?> clazz, List<CallbackInfo> callbackInfos, Set<Method> callbacks) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (CallbackInfo callbackInfo : callbackInfos) {
            try {
                Class<?> c;
                Method method = this.getMethod(clazz, callbackInfo.method, InvocationContext.class);
                if (callbackInfo.className == null && method.getDeclaringClass().equals(clazz) && !methods.contains(method)) {
                    methods.add(method);
                }
                if (method.getDeclaringClass().getName().equals(callbackInfo.className) && !methods.contains(method)) {
                    methods.add(method);
                    continue;
                }
                for (c = clazz; c != null && !c.getName().equals(callbackInfo.className); c = c.getSuperclass()) {
                }
                if (c == null) continue;
                try {
                    method = this.getMethod(c, callbackInfo.method, InvocationContext.class);
                    if (!Modifier.isPrivate(method.getModifiers()) || methods.contains(method)) continue;
                    SetAccessible.on(method);
                    methods.add(method);
                }
                catch (NoSuchMethodException e) {
                }
            }
            catch (NoSuchMethodException e) {
                logger.warning("Interceptor method not found (skipping): public Object " + callbackInfo.method + "(InvocationContext); in class " + clazz.getName());
            }
        }
        Collections.sort(methods, new MethodCallbackComparator());
        callbacks.addAll(methods);
    }

    private void toCallback(Class<?> clazz, List<CallbackInfo> callbackInfos, Set<Method> callbacks, Class<?> ... parameterTypes) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (CallbackInfo callbackInfo : callbackInfos) {
            try {
                Class<?> c;
                Method method = this.getMethod(clazz, callbackInfo.method, parameterTypes);
                if (callbackInfo.className == null && !methods.contains(method)) {
                    methods.add(method);
                    continue;
                }
                if (method.getDeclaringClass().getName().equals(callbackInfo.className) && !methods.contains(method)) {
                    methods.add(method);
                    continue;
                }
                for (c = clazz; c != null && !c.getName().equals(callbackInfo.className); c = c.getSuperclass()) {
                }
                if (c == null) continue;
                try {
                    method = c.getDeclaredMethod(callbackInfo.method, new Class[0]);
                    if (!Modifier.isPrivate(method.getModifiers()) || methods.contains(method)) continue;
                    SetAccessible.on(method);
                    methods.add(method);
                }
                catch (NoSuchMethodException e) {}
            }
            catch (NoSuchMethodException e) {
                String message = "Bean Callback method not found (skipping): public void " + callbackInfo.method + "(); in class " + clazz.getName();
                logger.warning(message);
                throw new IllegalStateException(message, e);
            }
        }
        Collections.sort(methods, new MethodCallbackComparator());
        callbacks.addAll(methods);
    }

    private Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        NoSuchMethodException original = null;
        while (clazz != null) {
            try {
                Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
                return SetAccessible.on(method);
            }
            catch (NoSuchMethodException e) {
                if (original == null) {
                    original = e;
                }
                clazz = clazz.getSuperclass();
            }
        }
        throw original;
    }

    private static Level level(InterceptorBindingInfo info) {
        if (info.ejbName.equals("*")) {
            return Level.PACKAGE;
        }
        if (info.method == null) {
            return info.className == null ? Level.CLASS : Level.ANNOTATION_CLASS;
        }
        if (info.method.methodParams == null) {
            return Level.OVERLOADED_METHOD;
        }
        return info.className == null ? Level.EXACT_METHOD : Level.ANNOTATION_METHOD;
    }

    private static Type type(Level level, InterceptorBindingInfo info) {
        if (info.interceptorOrder.size() > 0) {
            return Type.EXPLICIT_ORDERING;
        }
        if ((level == Level.CLASS || level == Level.ANNOTATION_CLASS) && info.excludeClassInterceptors && info.excludeDefaultInterceptors) {
            return Type.SAME_AND_LOWER_EXCLUSION;
        }
        if ((level == Level.CLASS || level == Level.ANNOTATION_CLASS) && info.excludeClassInterceptors) {
            return Type.SAME_LEVEL_EXCLUSION;
        }
        return Type.ADDITION_OR_LOWER_EXCLUSION;
    }

    public static class MethodCallbackComparator
    implements Comparator<Method> {
        @Override
        public int compare(Method m1, Method m2) {
            Class<?> c2;
            Class<?> c1 = m1.getDeclaringClass();
            if (c1.equals(c2 = m2.getDeclaringClass())) {
                return 0;
            }
            if (c1.isAssignableFrom(c2)) {
                return -1;
            }
            return 1;
        }
    }

    public static class IntercpetorBindingComparator
    implements Comparator<InterceptorBindingInfo> {
        @Override
        public int compare(InterceptorBindingInfo a, InterceptorBindingInfo b) {
            Level levelB;
            Level levelA = InterceptorBindingBuilder.level(a);
            if (levelA != (levelB = InterceptorBindingBuilder.level(b))) {
                return levelA.ordinal() - levelB.ordinal();
            }
            return InterceptorBindingBuilder.type(levelA, a).ordinal() - InterceptorBindingBuilder.type(levelB, b).ordinal();
        }
    }

    public static enum Type {
        ADDITION_OR_LOWER_EXCLUSION,
        SAME_LEVEL_EXCLUSION,
        SAME_AND_LOWER_EXCLUSION,
        EXPLICIT_ORDERING;

    }

    public static enum Level {
        PACKAGE,
        ANNOTATION_CLASS,
        CLASS,
        ANNOTATION_METHOD,
        OVERLOADED_METHOD,
        EXACT_METHOD;

    }
}

