/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.ClasspathArchive;
import org.apache.xbean.finder.archive.CompositeArchive;
import org.apache.xbean.finder.archive.FilteredArchive;
import org.apache.xbean.finder.filter.Filter;

public class AggregatedArchive
implements Archive {
    private final Map<URL, List<String>> classesMap = new HashMap<URL, List<String>>();
    private final Archive archive;

    public AggregatedArchive(ClassLoader loader, Iterable<URL> urls) {
        ArrayList<FilteredArchive> archives = new ArrayList<FilteredArchive>();
        for (URL url : urls) {
            final ArrayList classes = new ArrayList();
            FilteredArchive archive = new FilteredArchive(ClasspathArchive.archive((ClassLoader)loader, (URL)url), new Filter(){

                public boolean accept(String name) {
                    classes.add(name);
                    return true;
                }
            });
            this.classesMap.put(url, classes);
            archives.add(archive);
        }
        this.archive = new CompositeArchive(archives);
    }

    public InputStream getBytecode(String className) throws IOException, ClassNotFoundException {
        return this.archive.getBytecode(className);
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.archive.loadClass(className);
    }

    public Iterator<String> iterator() {
        return this.archive.iterator();
    }

    public Map<URL, List<String>> getClassesMap() {
        return this.classesMap;
    }
}

