/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config.rules;

import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.rules.ValidationBase;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.SessionBean;
import org.apache.openejb.jee.SessionType;
import org.apache.openejb.util.CircularReferencesException;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.LinkResolver;
import org.apache.openejb.util.References;

public class CheckDependsOn
extends ValidationBase {
    @Override
    public void validate(AppModule appModule) {
        this.module = appModule;
        LinkResolver app = new LinkResolver();
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            Resolver<Bean> resolver = new Resolver<Bean>(app, new LinkResolver());
            for (Object bean : ejbModule.getEjbJar().getEnterpriseBeans()) {
                Bean b = new Bean((EnterpriseBean)bean, ejbModule, ejbModule.getModuleUri(), resolver);
                ((Resolver)resolver).module.add(ejbModule.getModuleUri(), bean.getEjbName(), b);
                ((Resolver)resolver).app.add(ejbModule.getModuleUri(), bean.getEjbName(), b);
            }
        }
        boolean missingBeans = false;
        for (Bean bean : app.values()) {
            SessionBean sessionBean;
            EnterpriseBean enterpriseBean = bean.bean;
            if (!(enterpriseBean instanceof SessionBean) || (sessionBean = (SessionBean)enterpriseBean).getSessionType() != SessionType.SINGLETON) continue;
            for (String ejbName : sessionBean.getDependsOn()) {
                Bean referee = bean.resolveLink(ejbName);
                if (referee == null) {
                    bean.module.getValidation().fail(enterpriseBean.getEjbName(), "dependsOn.noSuchEjb", ejbName);
                    missingBeans = true;
                    continue;
                }
                bean.dependsOn.add(referee);
            }
        }
        try {
            References.sort(new ArrayList(app.values()), new References.Visitor<Bean>(){

                @Override
                public String getName(Bean t) {
                    return t.getId();
                }

                @Override
                public Set<String> getReferences(Bean t) {
                    LinkedHashSet<String> refs = new LinkedHashSet<String>();
                    for (Bean bean : t.dependsOn) {
                        refs.add(bean.getId());
                    }
                    return refs;
                }
            });
        }
        catch (CircularReferencesException e) {
            for (List circuit : e.getCircuits()) {
                ArrayList<String> ejbNames = new ArrayList<String>(circuit.size());
                for (Object bean : circuit) {
                    ejbNames.add(((Bean)bean).bean.getEjbName());
                }
                this.fail("EAR", "dependsOn.circuit", Join.join(" -> ", ejbNames), ejbNames.get(0));
            }
        }
    }

    public static class Bean {
        private final URI moduleUri;
        private final EnterpriseBean bean;
        private final ArrayList<Bean> dependsOn = new ArrayList();
        private final EjbModule module;
        private final Resolver<Bean> resolver;

        public Bean(EnterpriseBean bean, EjbModule module, URI moduleUri, Resolver<Bean> resolver) {
            this.bean = bean;
            this.module = module;
            this.moduleUri = moduleUri;
            this.resolver = resolver;
        }

        public Bean resolveLink(String ejbName) {
            return this.resolver.resolveLink(ejbName, this.moduleUri);
        }

        public String getId() {
            return this.toString();
        }
    }

    public static class Resolver<T> {
        private final LinkResolver<T> module;
        private final LinkResolver<T> app;

        public Resolver(LinkResolver<T> app, LinkResolver<T> module) {
            this.app = app;
            this.module = module;
        }

        public T resolveLink(String link, URI moduleUri) {
            T value = this.module.resolveLink(link, moduleUri);
            if (value != null) {
                return value;
            }
            return this.app.resolveLink(link, moduleUri);
        }
    }
}

