/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.IOException;
import java.net.ServerSocket;

public final class NetworkUtil {
    private NetworkUtil() {
    }

    public static int getNextAvailablePort() {
        return NetworkUtil.getNextAvailablePort(new int[]{0});
    }

    public static int getNextAvailablePort(int[] portList) {
        int port;
        ServerSocket s = null;
        try {
            s = NetworkUtil.create(portList);
            port = s.getLocalPort();
            s.close();
        }
        catch (IOException ioe) {
            port = -1;
        }
        return port;
    }

    private static ServerSocket create(int[] ports) throws IOException {
        for (int port : ports) {
            try {
                return new ServerSocket(port);
            }
            catch (IOException ex) {
            }
        }
        throw new IOException("no free port found");
    }

    public static String getLocalAddress(String start, String end) {
        return start + "localhost:" + NetworkUtil.getNextAvailablePort() + end;
    }
}

