/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.ssh;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.eclipse.equinox.console.common.KEYS;
import org.eclipse.equinox.console.common.terminal.ANSITerminalTypeMappings;
import org.eclipse.equinox.console.common.terminal.SCOTerminalTypeMappings;
import org.eclipse.equinox.console.common.terminal.TerminalTypeMappings;
import org.eclipse.equinox.console.common.terminal.VT100TerminalTypeMappings;
import org.eclipse.equinox.console.common.terminal.VT220TerminalTypeMappings;
import org.eclipse.equinox.console.common.terminal.VT320TerminalTypeMappings;
import org.eclipse.equinox.console.ssh.SshSession;
import org.osgi.framework.BundleContext;

public class SshShell
implements Command {
    private List<CommandProcessor> processors;
    private BundleContext context;
    private InputStream in;
    private OutputStream out;
    private ExitCallback callback;
    private Map<CommandProcessor, SshSession> commandProcessorToConsoleThreadMap = new HashMap<CommandProcessor, SshSession>();
    private final Map<String, TerminalTypeMappings> supportedEscapeSequences;
    private static final String DEFAULT_TTYPE = File.separatorChar == '/' ? "XTERM" : "ANSI";
    private TerminalTypeMappings currentMappings;
    private Map<String, KEYS> currentEscapesToKey;
    private static final String TERMINAL_PROPERTY = "TERM";

    public SshShell(List<CommandProcessor> processors, BundleContext context) {
        this.processors = processors;
        this.context = context;
        this.supportedEscapeSequences = new HashMap<String, TerminalTypeMappings>();
        this.supportedEscapeSequences.put("ANSI", (TerminalTypeMappings)new ANSITerminalTypeMappings());
        this.supportedEscapeSequences.put("WINDOWS", (TerminalTypeMappings)new ANSITerminalTypeMappings());
        this.supportedEscapeSequences.put("VT100", (TerminalTypeMappings)new VT100TerminalTypeMappings());
        VT220TerminalTypeMappings vtMappings = new VT220TerminalTypeMappings();
        this.supportedEscapeSequences.put("VT220", (TerminalTypeMappings)vtMappings);
        this.supportedEscapeSequences.put("XTERM", (TerminalTypeMappings)vtMappings);
        this.supportedEscapeSequences.put("VT320", (TerminalTypeMappings)new VT320TerminalTypeMappings());
        this.supportedEscapeSequences.put("SCO", (TerminalTypeMappings)new SCOTerminalTypeMappings());
        this.currentMappings = this.supportedEscapeSequences.get(DEFAULT_TTYPE);
        this.currentEscapesToKey = this.currentMappings.getEscapesToKey();
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setErrorStream(OutputStream err) {
    }

    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    public synchronized void start(Environment env) throws IOException {
        String term = (String)env.getEnv().get(TERMINAL_PROPERTY);
        TerminalTypeMappings mapping = this.supportedEscapeSequences.get(term.toUpperCase());
        if (mapping != null) {
            this.currentMappings = mapping;
            this.currentEscapesToKey = mapping.getEscapesToKey();
        }
        for (CommandProcessor processor : this.processors) {
            this.createNewSession(processor);
        }
    }

    public synchronized void addCommandProcessor(CommandProcessor processor) {
        this.createNewSession(processor);
    }

    public synchronized void removeCommandProcessor(CommandProcessor processor) {
        Thread consoleSession = this.commandProcessorToConsoleThreadMap.get(processor);
        if (consoleSession != null) {
            consoleSession.interrupt();
        }
    }

    private void createNewSession(CommandProcessor processor) {
        SshSession consoleSession = this.startNewConsoleSession(processor);
        this.commandProcessorToConsoleThreadMap.put(processor, consoleSession);
    }

    public void destroy() {
    }

    public void onExit() {
        if (this.commandProcessorToConsoleThreadMap.values() != null) {
            for (Thread thread : this.commandProcessorToConsoleThreadMap.values()) {
                thread.interrupt();
            }
        }
        this.callback.onExit(0);
    }

    public void removeSession(SshSession session) {
        CommandProcessor processorToRemove = null;
        for (CommandProcessor processor : this.commandProcessorToConsoleThreadMap.keySet()) {
            if (!session.equals(this.commandProcessorToConsoleThreadMap.get(processor))) continue;
            processorToRemove = processor;
            break;
        }
        if (processorToRemove != null) {
            this.commandProcessorToConsoleThreadMap.remove(processorToRemove);
        }
        if (this.commandProcessorToConsoleThreadMap.size() == 0) {
            this.onExit();
        }
    }

    private SshSession startNewConsoleSession(CommandProcessor processor) {
        SshSession consoleSession = new SshSession(processor, this.context, this, this.in, this.out, this.currentMappings, this.currentEscapesToKey);
        consoleSession.start();
        return consoleSession;
    }
}

