/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.api.GraphicConverter;
import writer2latex.office.MIMETypes;
import writer2latex.office.SVMReader;
import writer2latex.util.Base64;
import writer2latex.util.Misc;
import writer2latex.xmerge.BinaryGraphicsDocument;
import writer2latex.xmerge.EmbeddedBinaryObject;
import writer2latex.xmerge.EmbeddedObject;
import writer2latex.xmerge.OfficeDocument;

public final class ImageLoader {
    private OfficeDocument oooDoc;
    private String sBaseFileName = "";
    private String sSubDirName = "";
    private int nImageCount = 0;
    private NumberFormat formatter;
    private boolean bExtractEPS;
    private GraphicConverter gcv = null;
    private boolean bAcceptOtherFormats = true;
    private String sDefaultFormat = null;
    private String sDefaultVectorFormat = null;
    private HashSet<String> acceptedFormats = new HashSet();

    public ImageLoader(OfficeDocument oooDoc, boolean bExtractEPS) {
        this.oooDoc = oooDoc;
        this.bExtractEPS = bExtractEPS;
        this.formatter = new DecimalFormat("000");
    }

    public void setBaseFileName(String sBaseFileName) {
        this.sBaseFileName = sBaseFileName;
    }

    public void setUseSubdir(String sSubDirName) {
        this.sSubDirName = sSubDirName + "/";
    }

    public void setAcceptOtherFormats(boolean b) {
        this.bAcceptOtherFormats = b;
    }

    public void setDefaultFormat(String sMime) {
        this.addAcceptedFormat(sMime);
        this.sDefaultFormat = sMime;
    }

    public void setDefaultVectorFormat(String sMime) {
        this.addAcceptedFormat(sMime);
        this.sDefaultVectorFormat = sMime;
    }

    public void addAcceptedFormat(String sMime) {
        this.acceptedFormats.add(sMime);
    }

    private boolean isAcceptedFormat(String sMime) {
        return this.acceptedFormats.contains(sMime);
    }

    public void setGraphicConverter(GraphicConverter gcv) {
        this.gcv = gcv;
    }

    public BinaryGraphicsDocument getImage(Node node) {
        int[] offlen;
        String sMIME = null;
        String sExt = null;
        byte[] blob = null;
        String sHref = Misc.getAttribute(node, "xlink:href");
        if (sHref == null || sHref.length() == 0) {
            Element obd = Misc.getChildByTagName(node, "office:binary-data");
            if (obd != null) {
                StringBuffer buf = new StringBuffer();
                NodeList nl = obd.getChildNodes();
                int nLen = nl.getLength();
                for (int i = 0; i < nLen; ++i) {
                    if (nl.item(i).getNodeType() != 3) continue;
                    buf.append(nl.item(i).getNodeValue());
                }
                blob = Base64.decode(buf.toString());
                sMIME = MIMETypes.getMagicMIMEType(blob);
                sExt = MIMETypes.getFileExtension(sMIME);
            }
        } else {
            EmbeddedObject obj;
            if (sHref.startsWith("#")) {
                sHref = sHref.substring(1);
            }
            if (sHref.startsWith("./")) {
                sHref = sHref.substring(2);
            }
            if ((obj = this.oooDoc.getEmbeddedObject(sHref)) != null && obj instanceof EmbeddedBinaryObject) {
                EmbeddedBinaryObject object = (EmbeddedBinaryObject)obj;
                blob = object.getBinaryData();
                sMIME = object.getType();
                if (sMIME.length() > 0) {
                    sExt = MIMETypes.getFileExtension(sMIME);
                } else {
                    sMIME = MIMETypes.getMagicMIMEType(blob);
                    sExt = MIMETypes.getFileExtension(sMIME);
                }
            }
        }
        if (blob == null) {
            return null;
        }
        String sName = this.sSubDirName + this.sBaseFileName + this.formatter.format(++this.nImageCount);
        BinaryGraphicsDocument bgd = null;
        if (this.bExtractEPS && "application/x-openoffice-gdimetafile;windows_formatname=\"GDIMetaFile\"".equals(MIMETypes.getMagicMIMEType(blob)) && SVMReader.readSVM(blob, offlen = new int[2])) {
            bgd = new BinaryGraphicsDocument(sName, ".eps", "image/x-eps");
            bgd.read(blob, offlen[0], offlen[1]);
        }
        if (bgd == null) {
            if (this.gcv != null && !this.isAcceptedFormat(sMIME) && this.sDefaultFormat != null) {
                byte[] newBlob;
                String sTargetMIME = null;
                if (MIMETypes.isVectorFormat(sMIME) && this.sDefaultVectorFormat != null && this.gcv.supportsConversion(sMIME, this.sDefaultVectorFormat, false, false)) {
                    sTargetMIME = this.sDefaultVectorFormat;
                } else if (this.gcv.supportsConversion(sMIME, this.sDefaultFormat, false, false)) {
                    sTargetMIME = this.sDefaultFormat;
                }
                if (sTargetMIME != null && (newBlob = this.gcv.convert(blob, sMIME, sTargetMIME)) != null) {
                    blob = newBlob;
                    sMIME = sTargetMIME;
                    sExt = MIMETypes.getFileExtension(sMIME);
                }
            }
            if (this.isAcceptedFormat(sMIME) || this.bAcceptOtherFormats) {
                bgd = new BinaryGraphicsDocument(sName, sExt, sMIME);
                bgd.read(blob);
            }
        }
        return bgd;
    }
}

