/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Node;
import writer2latex.office.OfficeStyle;
import writer2latex.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OfficeStyleFamily {
    private Hashtable<String, Object> styles = new Hashtable();
    private Class styleClass;
    private Hashtable<String, String> displayNames = new Hashtable();
    private OfficeStyle defaultStyle = null;

    public OfficeStyleFamily(Class styleClass) {
        this.styleClass = styleClass;
    }

    public void setDefaultStyle(OfficeStyle style) {
        this.defaultStyle = style;
    }

    public OfficeStyle getDefaultStyle() {
        return this.defaultStyle;
    }

    public OfficeStyle getStyle(String sName) {
        if (sName == null) {
            return null;
        }
        return (OfficeStyle)this.styles.get(sName);
    }

    public OfficeStyle getStyleByDisplayName(String sDisplayName) {
        if (sDisplayName == null) {
            return null;
        }
        return this.getStyle(this.displayNames.get(sDisplayName));
    }

    public String getDisplayName(String sName) {
        OfficeStyle style = this.getStyle(sName);
        if (style == null) {
            return null;
        }
        if (style.isAutomatic() && (style = this.getStyle(style.getParentName())) == null) {
            return null;
        }
        return style.getDisplayName();
    }

    public Enumeration<Object> getStylesEnumeration() {
        return this.styles.elements();
    }

    public void loadStyleFromDOM(Node node, boolean bAutomatic) {
        String sName = Misc.getAttribute(node, "style:name");
        if (sName != null) {
            try {
                OfficeStyle style = (OfficeStyle)this.styleClass.newInstance();
                style.sName = sName;
                style.family = this;
                style.bAutomatic = bAutomatic;
                style.loadStyleFromDOM(node);
                this.styles.put(sName, style);
                if (!bAutomatic) {
                    this.displayNames.put(style.getDisplayName(), sName);
                }
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
    }
}

