/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xmerge;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import writer2latex.util.Misc;
import writer2latex.xmerge.Document;

public class BinaryGraphicsDocument
implements Document {
    private String docName;
    private byte[] data;
    private int nOff;
    private int nLen;
    private String sFileExtension;
    private String sMimeType;

    public BinaryGraphicsDocument(String name, String sFileExtension, String sMimeType) {
        this.sFileExtension = sFileExtension;
        this.sMimeType = sMimeType;
        this.docName = this.trimDocumentName(name);
    }

    public void read(InputStream is) throws IOException {
        this.data = Misc.inputStreamToByteArray(is);
    }

    public void read(byte[] data) {
        this.read(data, 0, data.length);
    }

    public void read(byte[] data, int nOff, int nLen) {
        this.data = data;
        this.nOff = nOff;
        this.nLen = nLen;
    }

    private String trimDocumentName(String name) {
        String temp = name.toLowerCase();
        if (temp.endsWith(this.getFileExtension())) {
            int nlen = name.length();
            int endIndex = nlen - this.getFileExtension().length();
            name = name.substring(0, endIndex);
        }
        return name;
    }

    public String getName() {
        return this.docName;
    }

    public String getFileName() {
        return new String(this.docName + this.getFileExtension());
    }

    public void write(OutputStream os) throws IOException {
        os.write(this.data, this.nOff, this.nLen);
    }

    public String getFileExtension() {
        return this.sFileExtension;
    }

    public String getDocumentMIMEType() {
        return this.sMimeType;
    }

    public String getMIMEType() {
        return this.sMimeType;
    }

    public boolean isMasterDocument() {
        return false;
    }
}

